/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.hibernate.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import nl.vpro.jackson2.Jackson2Mapper;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBridge
implements TwoWayStringBridge,
ParameterizedBridge {
    private static final Logger log = LoggerFactory.getLogger(JsonBridge.class);
    public static final int MAX_LENGTH = 32000;
    private Class<?> type;

    public Object stringToObject(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        try {
            return Jackson2Mapper.getLenientInstance().readValue(stringValue, this.type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String objectToString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            String ret = Jackson2Mapper.getInstance().writeValueAsString(object);
            int len = ret.length();
            if (len > 32000) {
                if (object instanceof Collection || object instanceof Object[]) {
                    Object[] array = object instanceof Object[] ? (Object[])object : ((Collection)object).stream().toArray(i -> new Object[((Collection)object).size()]);
                    int originalSize = array.length;
                    int size = array.length;
                    while (len > 32000 && array.length > 0) {
                        array = Arrays.copyOfRange(array, 0, --size);
                        ret = Jackson2Mapper.getInstance().writeValueAsString((Object)array);
                        len = ret.length();
                    }
                    if (size == 0) {
                        log.warn("Cannot store JSON representation of object type " + object.getClass().getName() + ": even first item in array already too large (maxlength = " + 32000 + ")");
                        return "[]";
                    }
                    log.warn("Truncated JSON representation of object type {}: {} -> {} ", new Object[]{object.getClass().getName(), originalSize, size});
                } else {
                    log.warn("Cannot store JSON representation of object type " + object.getClass().getName() + ": " + object + " (maxlength = " + 32000 + ")");
                    return "{}";
                }
            }
            return ret;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setParameterValues(Map<String, String> parameters) {
        try {
            String className = parameters.get("class");
            this.type = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }
}

