/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.hibernate;

import java.net.URI;
import java.net.URISyntaxException;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;

class URITypeDescriptor
extends AbstractTypeDescriptor<URI> {
    public static final URITypeDescriptor INSTANCE = new URITypeDescriptor();

    public URITypeDescriptor() {
        super(URI.class);
    }

    public String toString(URI value) {
        return value.toString();
    }

    public URI fromString(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException e) {
            throw new HibernateException("Unable to convert string [" + string + "] to URI : " + e);
        }
    }

    public <X> X unwrap(URI value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    public <X> URI wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

