/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class FalseToNullType
implements UserType {
    public static final FalseToNullType INSTANCE = new FalseToNullType();

    public int[] sqlTypes() {
        return new int[]{16};
    }

    public Class returnedClass() {
        return Boolean.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null) {
            x = Boolean.FALSE;
        }
        if (y == null) {
            y = Boolean.FALSE;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return 0;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Boolean result = rs.getBoolean(names[0]);
        if (result == null || !result.booleanValue()) {
            return null;
        }
        return result;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setBoolean(index, false);
        } else {
            st.setBoolean(index, (Boolean)value);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

