/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.hibernate.search;

import java.util.Collection;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;

public class CollectionSizeBridge<T>
implements FieldBridge,
MetadataProvidingFieldBridge {
    private final Function<T, Collection<?>> collectionFunction;
    private final String field;

    public CollectionSizeBridge(Function<T, Collection<?>> collectionFunction, String field) {
        this.collectionFunction = collectionFunction;
        this.field = field;
    }

    public CollectionSizeBridge() {
        this.collectionFunction = null;
        this.field = null;
    }

    protected long getLong(Object value) {
        if (this.collectionFunction == null) {
            return ((Collection)value).size();
        }
        return this.collectionFunction.apply(value).size();
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        long longValue = this.getLong(value);
        if (this.field != null) {
            name = this.field;
        }
        luceneOptions.addNumericFieldToDocument(name, (Object)longValue, document);
        document.add((IndexableField)new NumericDocValuesField(name, longValue));
    }

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(this.field, FieldType.LONG).sortable(true);
    }
}

