/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.hibernate;

import java.util.NoSuchElementException;
import java.util.function.Function;
import lombok.Generated;
import nl.vpro.util.CloseableIterator;
import org.hibernate.ScrollableResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollableResultsIterator<T>
implements CloseableIterator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScrollableResultsIterator.class);
    private final ScrollableResults scrollableResults;
    private final Function<ScrollableResults, T> adapter;
    private Boolean hasNext = null;
    private T next;

    public ScrollableResultsIterator(ScrollableResults r, Function<ScrollableResults, T> adapter) {
        this.scrollableResults = r;
        this.adapter = adapter;
    }

    public boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    public T next() {
        this.findNext();
        if (this.hasNext.booleanValue()) {
            this.hasNext = null;
            return this.next;
        }
        throw new NoSuchElementException();
    }

    protected void findNext() {
        block7: {
            if (this.hasNext == null) {
                this.hasNext = this.scrollableResults.next();
                if (this.hasNext.booleanValue()) {
                    while (true) {
                        try {
                            this.next = this.adapter.apply(this.scrollableResults);
                            break block7;
                        }
                        catch (Exception e) {
                            log.warn(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void close() {
        this.scrollableResults.close();
    }

    public String toString() {
        return "Iterator[" + this.scrollableResults + "]";
    }
}

