/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import nl.vpro.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringInstantToJsonTimestamp {
    private static final Logger log = LoggerFactory.getLogger(StringInstantToJsonTimestamp.class);
    private static Parser PARSER = new Parser(TimeZone.getTimeZone("Europe/Amsterdam"));

    static Instant parseDateTime(String value) {
        try {
            return DatatypeConverter.parseTime((String)value).toInstant();
        }
        catch (IllegalArgumentException iae) {
            try {
                List groups = PARSER.parse(value);
                if (groups.size() == 1) {
                    return DateUtils.toInstant((Date)((Date)((DateGroup)groups.get(0)).getDates().get(0)));
                }
            }
            catch (Exception e) {
                log.debug("Natty couldn't parse {}: {}", (Object)value, (Object)e.getMessage());
            }
            throw iae;
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Instant> {
        public static Deserializer INSTANCE = new Deserializer();

        public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            switch (jp.getCurrentTokenId()) {
                case 7: {
                    return Instant.ofEpochMilli(jp.getLongValue());
                }
                case 11: {
                    return null;
                }
                case 6: {
                    try {
                        return StringInstantToJsonTimestamp.parseDateTime(jp.getText());
                    }
                    catch (IllegalArgumentException iae) {
                        log.warn("Could not parse {}. Writing null to json", (Object)jp.getText());
                        return null;
                    }
                }
            }
            log.warn("Could not parse {} to instant. Returning null", (Object)jp.toString());
            return null;
        }
    }

    public static class Serializer
    extends JsonSerializer<Object> {
        public static Serializer INSTANCE = new Serializer();

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else if (value instanceof Instant) {
                jgen.writeNumber(((Instant)value).toEpochMilli());
            } else if (value instanceof CharSequence) {
                try {
                    jgen.writeNumber(StringInstantToJsonTimestamp.parseDateTime(String.valueOf(value)).toEpochMilli());
                }
                catch (IllegalArgumentException iae) {
                    log.warn("Could not parse {}. Writing null to json", value);
                    jgen.writeNull();
                }
            }
        }
    }
}

