/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import nl.vpro.jackson2.DateModule;
import nl.vpro.jackson2.Views;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson2Mapper
extends ObjectMapper {
    private static final Logger log = LoggerFactory.getLogger(Jackson2Mapper.class);
    private static boolean loggedAboutAvro = false;
    public static final Jackson2Mapper INSTANCE = new Jackson2Mapper("instance");
    public static final Jackson2Mapper LENIENT = new Jackson2Mapper("lenient");
    public static final Jackson2Mapper STRICT = new Jackson2Mapper("strict");
    public static final Jackson2Mapper PRETTY = new Jackson2Mapper("pretty");
    public static final Jackson2Mapper PUBLISHER = new Jackson2Mapper("publisher");
    public static final Jackson2Mapper PRETTY_PUBLISHER = new Jackson2Mapper("pretty_publisher");
    private static ThreadLocal<Jackson2Mapper> THREAD_LOCAL = ThreadLocal.withInitial(() -> INSTANCE);
    private final String toString;

    public static Jackson2Mapper getInstance() {
        return INSTANCE;
    }

    public static Jackson2Mapper getLenientInstance() {
        return LENIENT;
    }

    public static Jackson2Mapper getPrettyInstance() {
        return PRETTY;
    }

    public static Jackson2Mapper getPublisherInstance() {
        return PUBLISHER;
    }

    public static Jackson2Mapper getPrettyPublisherInstance() {
        return PRETTY_PUBLISHER;
    }

    public static Jackson2Mapper getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    public static void setThreadLocal(Jackson2Mapper set) {
        THREAD_LOCAL.set(set);
    }

    public static <T> T lenientTreeToValue(JsonNode jsonNode, Class<T> clazz) {
        return (T)Jackson2Mapper.getLenientInstance().treeToValue((TreeNode)jsonNode, clazz);
    }

    private Jackson2Mapper(String toString) {
        Jackson2Mapper.configureMapper(this);
        this.toString = toString;
    }

    public static void configureMapper(ObjectMapper mapper) {
        AnnotationIntrospectorPair introspector = new AnnotationIntrospectorPair((AnnotationIntrospector)new JacksonAnnotationIntrospector(), (AnnotationIntrospector)new JaxbAnnotationIntrospector(mapper.getTypeFactory()));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
        mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        mapper.enable(new MapperFeature[]{MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME});
        try {
            mapper.setConfig(mapper.getDeserializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS));
            mapper.setConfig(mapper.getDeserializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_JAVA_COMMENTS));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            log.warn(noClassDefFoundError.getMessage() + " temporary falling back. Please upgrade jackson");
            mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
            mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS});
        }
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new DateModule());
        Jdk8Module jdk8Module = new Jdk8Module();
        jdk8Module.configureAbsentsAsNulls(true);
        mapper.registerModule((Module)jdk8Module);
        mapper.setConfig(mapper.getSerializationConfig().withView(Views.Normal.class));
        mapper.setConfig(mapper.getDeserializationConfig().withView(Views.Normal.class));
        try {
            Class<?> avro = Class.forName("nl.vpro.jackson2.SerializeAvroModule");
            mapper.registerModule((Module)avro.newInstance());
        }
        catch (ClassNotFoundException ncdfe) {
            if (!loggedAboutAvro) {
                log.debug("SerializeAvroModule could not be registered because: " + ncdfe.getClass().getName() + " " + ncdfe.getMessage());
            }
            loggedAboutAvro = true;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error(e.getMessage(), (Throwable)e);
            loggedAboutAvro = true;
        }
    }

    public String toString() {
        return Jackson2Mapper.class.getSimpleName() + " (" + this.toString + ")";
    }

    static {
        LENIENT.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        STRICT.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        PRETTY.enable(SerializationFeature.INDENT_OUTPUT);
        PUBLISHER.setConfig(PUBLISHER.getSerializationConfig().withView(Views.Publisher.class));
        PUBLISHER.setConfig(PUBLISHER.getDeserializationConfig().withView(Views.Normal.class));
        PRETTY_PUBLISHER.setConfig(PUBLISHER.getSerializationConfig().withView(Views.Publisher.class));
        PRETTY_PUBLISHER.setConfig(PUBLISHER.getDeserializationConfig().withView(Views.Normal.class));
        PRETTY_PUBLISHER.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

