/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2.rs;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import nl.vpro.jackson2.Jackson2Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/json"})
public class JsonIdAdderBodyReader
implements MessageBodyReader<Object> {
    private static final Logger log = LoggerFactory.getLogger(JsonIdAdderBodyReader.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException, IOException {
        Jackson2Mapper mapper = Jackson2Mapper.getLenientInstance();
        JavaType javaType = mapper.getTypeFactory().constructType(genericType);
        JsonNode jsonNode = mapper.readTree(entityStream);
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            TypeDeserializer typeDeserializer = mapper.getDeserializationConfig().findTypeDeserializer(javaType);
            if (typeDeserializer != null) {
                String propertyName = typeDeserializer.getPropertyName();
                String propertyValue = typeDeserializer.getTypeIdResolver().idFromBaseType();
                if (!objectNode.has(propertyName)) {
                    log.debug("Implicetely setting {} = {} for {}", new Object[]{propertyName, propertyValue, javaType});
                    objectNode.put(propertyName, propertyValue);
                }
            }
        }
        return mapper.treeToValue((TreeNode)jsonNode, javaType.getRawClass());
    }
}

