/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Duration;

public class DurationToSecondsFloatTimestamp {
    private DurationToSecondsFloatTimestamp() {
    }

    public static class Deserializer
    extends JsonDeserializer<Duration> {
        public static final Deserializer INSTANCE = new Deserializer();

        public Duration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return Duration.ofMillis((long)(Float.parseFloat(jp.getValueAsString()) * 1000.0f));
        }
    }

    public static class Serializer
    extends JsonSerializer<Duration> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(Duration value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                jgen.writeNumber((float)value.toMillis() / 1000.0f);
            }
        }
    }
}

