/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class IterableJson {
    private static final Set<Class> simpleTypes = new HashSet<Class>(Arrays.asList(String.class, Character.class, Boolean.class, Integer.class, Float.class, Long.class, Double.class));

    public static abstract class Deserializer<T>
    extends JsonDeserializer<Iterable<T>> {
        private final Function<List<T>, Iterable<T>> creator;
        private final Class<T> memberClass;
        private final boolean isSimple;

        public Deserializer(Function<List<T>, Iterable<T>> supplier, Class<T> memberClass) {
            this.creator = supplier;
            this.memberClass = memberClass;
            this.isSimple = memberClass.isPrimitive() || simpleTypes.contains(memberClass);
        }

        public Deserializer(Function<List<T>, Iterable<T>> supplier) {
            this.creator = supplier;
            try {
                this.memberClass = (Class)supplier.getClass().getMethod("apply", new Class[0]).getReturnType().getGenericSuperclass();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException();
            }
            this.isSimple = this.memberClass.isPrimitive() || simpleTypes.contains(this.memberClass);
        }

        public Iterable<T> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getParsingContext().inObject()) {
                if (!this.isSimple) {
                    jp.clearCurrentToken();
                }
                Object rs = jp.readValueAs(this.memberClass);
                return this.creator.apply(Collections.singletonList(rs));
            }
            if (jp.getParsingContext().inArray()) {
                ArrayList list = new ArrayList();
                jp.clearCurrentToken();
                Iterator i = jp.readValuesAs(this.memberClass);
                while (i.hasNext()) {
                    list.add(i.next());
                }
                return this.creator.apply(list);
            }
            throw new IllegalStateException();
        }
    }

    public static class Serializer
    extends JsonSerializer<Iterable<?>> {
        public void serialize(Iterable value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                Iterator i = value.iterator();
                if (i.hasNext()) {
                    Object v = i.next();
                    if (!i.hasNext()) {
                        jgen.writeObject(v);
                    } else {
                        jgen.writeStartArray();
                        jgen.writeObject(v);
                        while (i.hasNext()) {
                            jgen.writeObject(i.next());
                        }
                        jgen.writeEndArray();
                    }
                } else {
                    jgen.writeStartArray();
                    jgen.writeEndArray();
                }
            }
        }
    }
}

