/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;

public class LocalDateTimeToJsonDateWithSpace {
    private LocalDateTimeToJsonDateWithSpace() {
    }

    public static class Deserializer
    extends JsonDeserializer<LocalDateTime> {
        public static final Deserializer INSTANCE = new Deserializer();

        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            if (text == null) {
                return null;
            }
            return LocalDateTime.parse(text.replaceFirst(" ", "T"));
        }
    }

    public static class Serializer
    extends JsonSerializer<LocalDateTime> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                jgen.writeString(value.toString().replaceFirst("T", " "));
            }
        }
    }
}

