/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import nl.vpro.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLDurationToJsonTimestamp {
    private static final Logger log = LoggerFactory.getLogger(XMLDurationToJsonTimestamp.class);

    public static class DeserializerJavaDuration
    extends JsonDeserializer<java.time.Duration> {
        public java.time.Duration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return java.time.Duration.ofMillis(jp.getLongValue());
        }
    }

    public static class SerializerString
    extends JsonSerializer<String> {
        public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            java.time.Duration duration = TimeUtils.parseDuration((CharSequence)value).orElse(null);
            if (duration != null) {
                jgen.writeNumber(duration.toMillis());
            } else {
                jgen.writeNull();
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Duration> {
        public Duration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
                return datatypeFactory.newDuration(jp.getLongValue());
            }
            catch (DatatypeConfigurationException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }

    public static class DeserializerDate
    extends JsonDeserializer<Date> {
        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return new Date(jp.getLongValue());
        }
    }

    public static class Serializer
    extends JsonSerializer<Duration> {
        public void serialize(Duration value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            cal.setTimeInMillis(0L);
            jgen.writeNumber(value.getTimeInMillis(cal));
        }
    }
}

