/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterUnmarshalDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    private static final Logger log = LoggerFactory.getLogger(AfterUnmarshalDeserializer.class);
    private static final String AFTER_UNMARSHAL = "afterUnmarshal";
    private static final String CLASS_POSTFIX = "$$DefaultJsonDeserialize";
    private static ClassPool POOL;

    public AfterUnmarshalDeserializer() {
        super(Object.class);
    }

    protected AfterUnmarshalDeserializer(JavaType clazz) {
        super(clazz);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object parent = AfterUnmarshalDeserializer.getParent(p);
        Object obj = this.deserializeObject(p, ctxt);
        AfterUnmarshalDeserializer.invokeAfterUnmarshal(ctxt, obj, parent);
        return obj;
    }

    protected Object deserializeObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object deserialized = p.getCodec().treeToValue((TreeNode)ctxt.readTree(p), AfterUnmarshalDeserializer.extension(this._valueClass));
        return deserialized;
    }

    public static Object getParent(JsonParser p) {
        JsonStreamContext parentStreamContext = p.getParsingContext().getParent();
        Object parent = null;
        if (parentStreamContext != null && (parent = parentStreamContext.getCurrentValue()) instanceof Collection && parentStreamContext.getParent() != null) {
            parent = parentStreamContext.getParent().getCurrentValue();
        }
        return parent;
    }

    public static void invokeAfterUnmarshal(DeserializationContext cxt, Object obj, Object parent) throws JsonProcessingException {
        try {
            Class<?> valueClass = obj.getClass();
            try {
                AfterUnmarshalDeserializer.getAfterUnmarshal(valueClass, DeserializationContext.class, Object.class).invoke(obj, cxt, parent);
            }
            catch (NoSuchMethodException nsfme) {
                try {
                    AfterUnmarshalDeserializer.getAfterUnmarshal(valueClass, Object.class).invoke(obj, parent);
                }
                catch (NoSuchMethodException nsme) {
                    AfterUnmarshalDeserializer.getAfterUnmarshal(valueClass, Unmarshaller.class, Object.class).invoke(obj, null, parent);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JsonProcessingException(e){};
        }
    }

    private static Method getAfterUnmarshal(Class<?> clazz, Class<?> ... args) throws NoSuchMethodException {
        while (true) {
            try {
                Method m = clazz.getDeclaredMethod(AFTER_UNMARSHAL, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException nsme) {
                if ((clazz = clazz.getSuperclass()) != Object.class) continue;
                throw nsme;
            }
            break;
        }
    }

    public static Class<?> extension(Class<?> valueClass) {
        CtClass copy;
        String name = valueClass.getName() + CLASS_POSTFIX;
        if (POOL == null) {
            POOL = ClassPool.getDefault();
            POOL.insertClassPath((ClassPath)new ClassClassPath(AfterUnmarshalDeserializer.class));
        }
        if ((copy = POOL.getOrNull(name)) == null) {
            CtClass ctClass = POOL.getCtClass(valueClass.getName());
            copy = POOL.makeClass(name, ctClass);
            ClassFile classFile = copy.getClassFile();
            ConstPool constpool = classFile.getConstPool();
            AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(JsonDeserialize.class.getName(), constpool);
            annotationsAttribute.setAnnotation(annotation);
            classFile.addAttribute((AttributeInfo)annotationsAttribute);
            copy.toBytecode();
            Class clazz = copy.toClass(AfterUnmarshalDeserializer.class.getClassLoader(), AfterUnmarshalDeserializer.class.getProtectionDomain());
            log.info("Created {}", (Object)clazz);
            return clazz;
        }
        return AfterUnmarshalDeserializer.class.getClassLoader().loadClass(name);
    }

    public AfterUnmarshalDeserializer createContextual(DeserializationContext ctxt, BeanProperty property) {
        return new AfterUnmarshalDeserializer(ctxt.getContextualType());
    }
}

