/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import nl.vpro.jackson2.DateModule;
import nl.vpro.jackson2.Views;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson2Mapper
extends ObjectMapper {
    private static final Logger log = LoggerFactory.getLogger(Jackson2Mapper.class);
    private static boolean loggedAboutAvro = false;
    public static Jackson2Mapper INSTANCE = new Jackson2Mapper();
    public static Jackson2Mapper LENIENT = new Jackson2Mapper();
    public static Jackson2Mapper STRICT = new Jackson2Mapper();
    public static Jackson2Mapper PRETTY = new Jackson2Mapper();
    public static Jackson2Mapper PUBLISHER = new Jackson2Mapper();
    public static Jackson2Mapper PRETTY_PUBLISHER = new Jackson2Mapper();

    public static Jackson2Mapper getInstance() {
        return INSTANCE;
    }

    public static Jackson2Mapper getLenientInstance() {
        return LENIENT;
    }

    public static Jackson2Mapper getPrettyInstance() {
        return PRETTY;
    }

    public static Jackson2Mapper getPublisherInstance() {
        return PUBLISHER;
    }

    public static <T> T lenientTreeToValue(JsonNode jsonNode, Class<T> clazz) {
        return (T)Jackson2Mapper.getLenientInstance().treeToValue((TreeNode)jsonNode, clazz);
    }

    private Jackson2Mapper() {
        AnnotationIntrospectorPair introspector = new AnnotationIntrospectorPair((AnnotationIntrospector)new JacksonAnnotationIntrospector(), (AnnotationIntrospector)new JaxbAnnotationIntrospector(this.getTypeFactory()));
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
        this.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        this.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        this.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS});
        this.enable(new MapperFeature[]{MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME});
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        this.registerModule((Module)javaTimeModule);
        this.registerModule((Module)new DateModule());
        this.setConfig(this.getSerializationConfig().withView(Views.Normal.class));
        this.setConfig(this.getDeserializationConfig().withView(Views.Normal.class));
        try {
            Class<?> avro = Class.forName("nl.vpro.jackson2.SerializeAvroModule");
            this.registerModule((Module)avro.newInstance());
        }
        catch (ClassNotFoundException ncdfe) {
            if (!loggedAboutAvro) {
                log.debug("SerializeAvroModule could not be registered because: " + ncdfe.getClass().getName() + " " + ncdfe.getMessage());
            }
            loggedAboutAvro = true;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error(e.getMessage(), (Throwable)e);
            loggedAboutAvro = true;
        }
    }

    static {
        LENIENT.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
        STRICT.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        PRETTY.enable(SerializationFeature.INDENT_OUTPUT);
        PUBLISHER.setConfig(PUBLISHER.getSerializationConfig().withView(Views.Publisher.class));
        PUBLISHER.setConfig(PUBLISHER.getDeserializationConfig().withView(Views.Normal.class));
        PRETTY_PUBLISHER.setConfig(PUBLISHER.getSerializationConfig().withView(Views.Publisher.class));
        PRETTY_PUBLISHER.setConfig(PUBLISHER.getDeserializationConfig().withView(Views.Normal.class));
        PRETTY_PUBLISHER.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

