/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDate;

public class LocalDateToJsonDate {
    private LocalDateToJsonDate() {
    }

    public static class Deserializer
    extends JsonDeserializer<LocalDate> {
        public static final Deserializer INSTANCE = new Deserializer();

        public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            if (text == null) {
                return null;
            }
            return LocalDate.parse(text);
        }
    }

    public static class Serializer
    extends JsonSerializer<LocalDate> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(LocalDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                jgen.writeString(value.toString());
            }
        }
    }
}

