/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Duration;

public class StringDurationToJsonTimestamp {
    private StringDurationToJsonTimestamp() {
    }

    public static class Deserializer
    extends JsonDeserializer<String> {
        public static final Deserializer INSTANCE = new Deserializer();

        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Duration.ofMillis(jp.getLongValue()).toString();
        }
    }

    public static class Serializer
    extends JsonSerializer<String> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(String value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                jgen.writeNumber(Duration.parse(value).toMillis());
            }
        }
    }
}

