/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import nl.vpro.jackson2.Jackson2Mapper;
import nl.vpro.util.CloseableIterator;
import nl.vpro.util.CountedIterator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonArrayIterator<T>
extends UnmodifiableIterator<T>
implements CloseableIterator<T>,
PeekingIterator<T>,
CountedIterator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonArrayIterator.class);
    private final JsonParser jp;
    private T next = null;
    private boolean needsFindNext = true;
    private Boolean hasNext;
    private final BiFunction<JsonParser, TreeNode, ? extends T> valueCreator;
    private Runnable callback;
    private boolean callBackHasRun = false;
    private final Long size;
    private final Long totalSize;
    private int foundNulls = 0;
    private Logger logger = log;
    private long count = 0L;
    private boolean skipNulls = true;

    public JsonArrayIterator(InputStream inputStream, Class<T> clazz) throws IOException {
        this(inputStream, clazz, null);
    }

    public JsonArrayIterator(InputStream inputStream, Class<T> clazz, Runnable callback) throws IOException {
        this(inputStream, null, clazz, callback, null, null, null, null, null);
    }

    public JsonArrayIterator(InputStream inputStream, BiFunction<JsonParser, TreeNode, T> valueCreator) throws IOException {
        this(inputStream, valueCreator, null, null, null, null, null, null, null);
    }

    private JsonArrayIterator(@NonNull InputStream inputStream, @Nullable BiFunction<JsonParser, TreeNode, T> valueCreator, @Nullable Class<T> valueClass, @Nullable Runnable callback, @Nullable String sizeField, @Nullable String totalSizeField, @Nullable ObjectMapper objectMapper, @Nullable Logger logger, @Nullable Boolean skipNulls) throws IOException {
        JsonToken token;
        if (inputStream == null) {
            throw new IllegalArgumentException("No inputStream given");
        }
        this.jp = (objectMapper == null ? Jackson2Mapper.getLenientInstance() : objectMapper).getFactory().createParser(inputStream);
        BiFunction<JsonParser, TreeNode, Object> biFunction = this.valueCreator = valueCreator == null ? JsonArrayIterator.valueCreator(valueClass) : valueCreator;
        if (valueCreator != null && valueClass != null) {
            throw new IllegalArgumentException();
        }
        if (logger != null) {
            this.logger = logger;
        }
        Long tmpSize = null;
        Long tmpTotalSize = null;
        String fieldName = null;
        if (sizeField == null) {
            sizeField = "size";
        }
        if (totalSizeField == null) {
            totalSizeField = "totalSize";
        }
        while ((token = this.jp.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                fieldName = this.jp.getCurrentName();
            }
            if (token == JsonToken.VALUE_NUMBER_INT && sizeField.equals(fieldName)) {
                tmpSize = this.jp.getLongValue();
            }
            if (token == JsonToken.VALUE_NUMBER_INT && totalSizeField.equals(fieldName)) {
                tmpTotalSize = this.jp.getLongValue();
            }
            if (token != JsonToken.START_ARRAY) continue;
            break;
        }
        this.size = tmpSize;
        this.totalSize = tmpTotalSize;
        this.jp.nextToken();
        this.callback = callback;
        this.skipNulls = skipNulls == null || skipNulls != false;
    }

    private static <T> BiFunction<JsonParser, TreeNode, T> valueCreator(Class<T> clazz) {
        return (jp, tree) -> {
            try {
                return jp.getCodec().treeToValue(tree, clazz);
            }
            catch (JsonProcessingException e) {
                throw new ValueReadException(e);
            }
        };
    }

    public boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    public T peek() {
        this.findNext();
        return this.next;
    }

    public T next() {
        this.findNext();
        if (!this.hasNext.booleanValue()) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.next = null;
        this.needsFindNext = true;
        this.hasNext = null;
        this.count += (long)this.foundNulls;
        this.foundNulls = 0;
        ++this.count;
        return result;
    }

    public Long getCount() {
        return this.count;
    }

    protected void findNext() {
        if (this.needsFindNext) {
            block5: while (true) {
                try {
                    while (true) {
                        TreeNode tree = this.jp.readValueAsTree();
                        if (this.jp.getLastClearedToken() == JsonToken.END_ARRAY) {
                            tree = null;
                        } else if (tree instanceof NullNode && this.skipNulls) {
                            ++this.foundNulls;
                            continue;
                        }
                        try {
                            if (tree == null) {
                                this.callback();
                                this.hasNext = false;
                                break block5;
                            }
                            if (this.foundNulls > 0) {
                                this.logger.warn("Found {} nulls. Will be skipped", (Object)this.foundNulls);
                            }
                            this.next = this.valueCreator.apply(this.jp, tree);
                            this.hasNext = true;
                            break block5;
                        }
                        catch (ValueReadException jme) {
                            ++this.foundNulls;
                            this.logger.warn(jme.getClass() + " " + jme.getMessage() + " for\n" + tree + "\nWill be skipped");
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    this.callbackBeforeThrow(new RuntimeException(e));
                    continue;
                }
                catch (RuntimeException rte) {
                    this.callbackBeforeThrow(rte);
                    continue;
                }
                break;
            }
            this.needsFindNext = false;
        }
    }

    private void callbackBeforeThrow(RuntimeException e) {
        this.callback();
        this.next = null;
        this.needsFindNext = false;
        this.hasNext = false;
        throw e;
    }

    public void close() throws IOException {
        this.callback();
        this.jp.close();
    }

    public void finalize() {
        if (!this.callBackHasRun && this.callback != null) {
            this.logger.warn("Callback not run in finalize. Did you not close the iterator?");
            this.callback.run();
        }
    }

    protected void callback() {
        if (!this.callBackHasRun) {
            if (this.callback != null) {
                this.callback.run();
            }
            this.callBackHasRun = true;
        }
    }

    public void write(OutputStream out, Consumer<T> logging) throws IOException {
        JsonArrayIterator.write(this, out, logging == null ? null : c -> {
            logging.accept(c);
            return null;
        });
    }

    public void writeArray(OutputStream out, Consumer<T> logging) throws IOException {
        JsonArrayIterator.writeArray(this, out, logging == null ? null : c -> {
            logging.accept(c);
            return null;
        });
    }

    public void write(OutputStream out, Function<T, Void> logging) throws IOException {
        JsonArrayIterator.write(this, out, logging);
    }

    public static <T> void write(CountedIterator<T> iterator, OutputStream out, Function<T, Void> logging) throws IOException {
        try (JsonGenerator jg = Jackson2Mapper.getInstance().getFactory().createGenerator(out);){
            jg.writeStartObject();
            jg.writeArrayFieldStart("array");
            JsonArrayIterator.writeObjects(iterator, jg, logging);
            jg.writeEndArray();
            jg.writeEndObject();
            jg.flush();
        }
    }

    public static <T> void writeArray(CountedIterator<T> iterator, OutputStream out, Function<T, Void> logging) throws IOException {
        try (JsonGenerator jg = Jackson2Mapper.getInstance().getFactory().createGenerator(out);){
            jg.writeStartArray();
            JsonArrayIterator.writeObjects(iterator, jg, logging);
            jg.writeEndArray();
            jg.flush();
        }
    }

    public static <T> void writeObjects(CountedIterator<T> iterator, JsonGenerator jg, Function<T, Void> logging) throws IOException {
        while (iterator.hasNext()) {
            try {
                Object change = iterator.next();
                if (change != null) {
                    jg.writeObject(change);
                } else {
                    jg.writeNull();
                }
                if (logging == null) continue;
                logging.apply(change);
            }
            catch (Exception e) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof InterruptedException)) continue;
                    return;
                }
                log.warn(e.getClass().getCanonicalName() + " " + e.getMessage());
                jg.writeObject((Object)e.getMessage());
            }
        }
    }

    public @NonNull Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    public @NonNull Optional<Long> getTotalSize() {
        return Optional.ofNullable(this.totalSize);
    }

    @Generated
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated
    public Runnable getCallback() {
        return this.callback;
    }

    @Generated
    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    @Generated
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public static class ValueReadException
    extends RuntimeException {
        public ValueReadException(JsonProcessingException e) {
            super(e);
        }
    }

    public static class Builder<T> {
        @Generated
        private InputStream inputStream;
        @Generated
        private BiFunction<JsonParser, TreeNode, T> valueCreator;
        @Generated
        private Class<T> valueClass;
        @Generated
        private Runnable callback;
        @Generated
        private String sizeField;
        @Generated
        private String totalSizeField;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private Logger logger;
        @Generated
        private Boolean skipNulls;

        @Generated
        Builder() {
        }

        @Generated
        public Builder<T> inputStream(@NonNull InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        @Generated
        public Builder<T> valueCreator(@Nullable BiFunction<JsonParser, TreeNode, T> valueCreator) {
            this.valueCreator = valueCreator;
            return this;
        }

        @Generated
        public Builder<T> valueClass(@Nullable Class<T> valueClass) {
            this.valueClass = valueClass;
            return this;
        }

        @Generated
        public Builder<T> callback(@Nullable Runnable callback) {
            this.callback = callback;
            return this;
        }

        @Generated
        public Builder<T> sizeField(@Nullable String sizeField) {
            this.sizeField = sizeField;
            return this;
        }

        @Generated
        public Builder<T> totalSizeField(@Nullable String totalSizeField) {
            this.totalSizeField = totalSizeField;
            return this;
        }

        @Generated
        public Builder<T> objectMapper(@Nullable ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public Builder<T> logger(@Nullable Logger logger) {
            this.logger = logger;
            return this;
        }

        @Generated
        public Builder<T> skipNulls(@Nullable Boolean skipNulls) {
            this.skipNulls = skipNulls;
            return this;
        }

        @Generated
        public JsonArrayIterator<T> build() throws IOException {
            return new JsonArrayIterator(this.inputStream, this.valueCreator, this.valueClass, this.callback, this.sizeField, this.totalSizeField, this.objectMapper, this.logger, this.skipNulls);
        }

        @Generated
        public String toString() {
            return "JsonArrayIterator.Builder(inputStream=" + this.inputStream + ", valueCreator=" + this.valueCreator + ", valueClass=" + this.valueClass + ", callback=" + this.callback + ", sizeField=" + this.sizeField + ", totalSizeField=" + this.totalSizeField + ", objectMapper=" + this.objectMapper + ", logger=" + this.logger + ", skipNulls=" + this.skipNulls + ")";
        }
    }
}

