/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import nl.vpro.jackson2.NattySupport;
import nl.vpro.logging.Slf4jHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class StringInstantToJsonTimestamp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringInstantToJsonTimestamp.class);
    private static boolean warnedNatty = false;

    private StringInstantToJsonTimestamp() {
    }

    static Instant parseDateTime(String value) {
        try {
            long asLong = Long.parseLong(value);
            return Instant.ofEpochMilli(asLong);
        }
        catch (NumberFormatException asLong) {
            try {
                return DatatypeConverter.parseTime((String)value).toInstant();
            }
            catch (IllegalArgumentException iae) {
                try {
                    Optional<Instant> natty = NattySupport.parseDate(value);
                    if (natty.isPresent()) {
                        return natty.get();
                    }
                    log.debug("Natty din't match");
                }
                catch (NoClassDefFoundError classNotFoundException) {
                    warnedNatty = true;
                    Slf4jHelper.log((Logger)log, (Level)(warnedNatty ? Level.DEBUG : Level.WARN), (String)("No natty?: " + classNotFoundException.getMessage()));
                }
                catch (Throwable e) {
                    log.debug("Natty couldn't parse {}: {}", (Object)value, (Object)e.getMessage());
                }
                throw iae;
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Instant> {
        public static final Deserializer INSTANCE = new Deserializer();

        public Instant deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            switch (jp.getCurrentTokenId()) {
                case 7: {
                    return Instant.ofEpochMilli(jp.getLongValue());
                }
                case 11: {
                    return null;
                }
                case 6: {
                    try {
                        return StringInstantToJsonTimestamp.parseDateTime(jp.getText());
                    }
                    catch (IllegalArgumentException iae) {
                        log.warn("Could not parse {}. Writing null to json", (Object)jp.getText());
                        return null;
                    }
                }
            }
            log.warn("Could not parse {} to instant. Returning null", (Object)jp.toString());
            return null;
        }
    }

    public static class Serializer
    extends JsonSerializer<Object> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else if (value instanceof Instant) {
                jgen.writeNumber(((Instant)value).toEpochMilli());
            } else if (value instanceof CharSequence) {
                try {
                    jgen.writeNumber(StringInstantToJsonTimestamp.parseDateTime(String.valueOf(value)).toEpochMilli());
                }
                catch (IllegalArgumentException iae) {
                    log.warn("Could not parse {}. Writing null to json", value);
                    jgen.writeNull();
                }
            }
        }
    }
}

