/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Duration;

public class DurationToJsonTimestamp {

    public static class Deserializer
    extends JsonDeserializer<Duration> {
        public static Deserializer INSTANCE = new Deserializer();

        public Duration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            if (jp.getCurrentToken() == JsonToken.VALUE_STRING) {
                if (jp.getText().isEmpty() && ctxt.hasDeserializationFeatures(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT.getMask())) {
                    return null;
                }
                return Duration.ofMillis(Long.parseLong(jp.getText()));
            }
            return Duration.ofMillis(jp.getLongValue());
        }
    }

    public static class Serializer
    extends JsonSerializer<Duration> {
        public static Serializer INSTANCE = new Serializer();

        public void serialize(Duration value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                jgen.writeNumber(value.toMillis());
            }
        }
    }
}

