/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackwardsCompatibleJsonEnum {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackwardsCompatibleJsonEnum.class);

    public static abstract class Deserializer<T extends Enum<T>>
    extends JsonDeserializer<T> {
        final Class<T> enumClass;

        public Deserializer(Class<T> enumClass) {
            this.enumClass = enumClass;
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return Enum.valueOf(this.enumClass, jp.getValueAsString());
            }
            catch (IllegalArgumentException iae) {
                try {
                    return Enum.valueOf(this.enumClass, jp.getValueAsString().toUpperCase());
                }
                catch (IllegalArgumentException iaeu) {
                    if (ctxt.getConfig().hasDeserializationFeatures(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL.getMask())) {
                        return null;
                    }
                    throw iae;
                }
            }
        }
    }

    public static class Serializer
    extends JsonSerializer<Enum<?>> {
        public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                jgen.writeNull();
            } else {
                jgen.writeString(value.name());
            }
        }
    }
}

