/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import lombok.Generated;

@Deprecated
public class JsonFilter
implements Callable<Void> {
    static JsonFactory factory = new JsonFactory();
    final InputStream in;
    final OutputStream out;
    final List<Replacement<?>> replacements;

    public JsonFilter(InputStream in, OutputStream out, List<Replacement<?>> replacements) {
        this.in = in;
        this.out = out;
        this.replacements = replacements;
    }

    private <T> T handleReplacements(Deque<String> stack, T value) {
        String fieldName = stack.poll();
        for (Replacement<?> replacement : this.replacements) {
            if (!replacement.key.equals(fieldName) || !replacement.test(value)) continue;
            return replacement.newValue;
        }
        return value;
    }

    @Override
    public Void call() throws IOException {
        try (JsonParser parser = factory.createParser(this.in);){
            Void void_;
            block27: {
                JsonGenerator generator = factory.createGenerator(this.out);
                try {
                    JsonToken token;
                    ArrayDeque<String> stack = new ArrayDeque<String>();
                    while ((token = parser.nextToken()) != null) {
                        switch (token) {
                            case START_OBJECT: {
                                generator.writeStartObject();
                                break;
                            }
                            case END_OBJECT: {
                                generator.writeEndObject();
                                break;
                            }
                            case START_ARRAY: {
                                generator.writeStartArray();
                                break;
                            }
                            case END_ARRAY: {
                                generator.writeEndArray();
                                break;
                            }
                            case FIELD_NAME: {
                                String fieldName = parser.getText();
                                generator.writeFieldName(fieldName);
                                stack.push(fieldName);
                                break;
                            }
                            case VALUE_EMBEDDED_OBJECT: {
                                stack.poll();
                                break;
                            }
                            case VALUE_STRING: {
                                generator.writeString(this.handleReplacements(stack, parser.getText()));
                                break;
                            }
                            case VALUE_NUMBER_INT: {
                                generator.writeNumber(this.handleReplacements(stack, parser.getValueAsInt()).intValue());
                                break;
                            }
                            case VALUE_NUMBER_FLOAT: {
                                generator.writeNumber(this.handleReplacements(stack, parser.getValueAsDouble()).doubleValue());
                                break;
                            }
                            case VALUE_TRUE: {
                                generator.writeBoolean(true);
                                stack.poll();
                                break;
                            }
                            case VALUE_FALSE: {
                                generator.writeBoolean(false);
                                stack.poll();
                                break;
                            }
                            case VALUE_NULL: {
                                generator.writeNull();
                                stack.poll();
                            }
                        }
                    }
                    void_ = null;
                    if (generator == null) break block27;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return void_;
        }
    }

    static {
        factory.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        factory.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        factory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        factory.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    public static class Replacement<T>
    implements Predicate<Object> {
        private final String key;
        private final T newValue;
        private final Predicate<Object> wrapped;

        public Replacement(String key, T value, T newValue) {
            this.key = key;
            this.wrapped = currentValue -> Objects.equals(value, currentValue);
            this.newValue = newValue;
        }

        public Replacement(String key, T newValue) {
            this.key = key;
            this.newValue = newValue;
            this.wrapped = currentValue -> true;
        }

        private Replacement(String key, T newValue, Predicate<Object> predicate) {
            this.key = key;
            this.newValue = newValue;
            this.wrapped = predicate;
        }

        @Override
        public boolean test(Object currentValue) {
            return this.wrapped.test(currentValue);
        }

        @Generated
        public static <T> Builder<T> builder() {
            return new Builder();
        }

        @Generated
        public String toString() {
            return "JsonFilter.Replacement(key=" + this.key + ", newValue=" + this.newValue + ", wrapped=" + this.wrapped + ")";
        }

        @Generated
        public static class Builder<T> {
            @Generated
            private String key;
            @Generated
            private T newValue;
            @Generated
            private Predicate<Object> predicate;

            @Generated
            Builder() {
            }

            @Generated
            public Builder<T> key(String key) {
                this.key = key;
                return this;
            }

            @Generated
            public Builder<T> newValue(T newValue) {
                this.newValue = newValue;
                return this;
            }

            @Generated
            public Builder<T> predicate(Predicate<Object> predicate) {
                this.predicate = predicate;
                return this;
            }

            @Generated
            public Replacement<T> build() {
                return new Replacement<T>(this.key, this.newValue, this.predicate);
            }

            @Generated
            public String toString() {
                return "JsonFilter.Replacement.Builder(key=" + this.key + ", newValue=" + this.newValue + ", predicate=" + this.predicate + ")";
            }
        }
    }
}

