/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public class LenientBooleanDeserializer
extends JsonDeserializer<Boolean> {
    public static final LenientBooleanDeserializer INSTANCE = new LenientBooleanDeserializer();

    private LenientBooleanDeserializer() {
    }

    public Boolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String text;
        JsonToken token = jsonParser.getCurrentToken();
        if (jsonParser.isNaN()) {
            return false;
        }
        if (token.isBoolean()) {
            return jsonParser.getBooleanValue();
        }
        if (token.isNumeric()) {
            return jsonParser.getNumberValue().longValue() != 0L;
        }
        switch (text = jsonParser.getText().toLowerCase()) {
            case "true": 
            case "1": {
                return true;
            }
        }
        return false;
    }
}

