/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jackson2.rs;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Priority;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import lombok.Generated;
import nl.vpro.jackson2.Jackson2Mapper;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/json"})
@Priority(value=4999)
public class JsonIdAdderBodyReader
implements MessageBodyReader<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonIdAdderBodyReader.class);
    @Context
    Providers providers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(@NonNull Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException, IOException {
        ObjectMapper mapper;
        ObjectMapper objectMapper = mapper = this.providers == null ? null : (ObjectMapper)this.providers.getContextResolver(ObjectMapper.class, MediaType.APPLICATION_JSON_TYPE).getContext(type);
        if (mapper == null) {
            log.info("No mapper found in {}", (Object)this.providers);
            mapper = Jackson2Mapper.getLenientInstance();
        }
        JavaType javaType = mapper.getTypeFactory().constructType(genericType);
        JsonNode jsonNode = mapper.readTree(entityStream);
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            TypeDeserializer typeDeserializer = mapper.getDeserializationConfig().findTypeDeserializer(javaType);
            if (typeDeserializer != null) {
                String propertyName = typeDeserializer.getPropertyName();
                String propertyValue = typeDeserializer.getTypeIdResolver().idFromBaseType();
                if (!objectNode.has(propertyName)) {
                    log.debug("Implicitly setting {} = {} for {}", new Object[]{propertyName, propertyValue, javaType});
                    objectNode.put(propertyName, propertyValue);
                }
            }
        }
        return mapper.treeToValue((TreeNode)jsonNode, javaType.getRawClass());
    }
}

