/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.util.rs.interceptors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Provider
@PreMatching
public class LoggingInterceptor
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String method = requestContext.getMethod();
        if ("POST".equals(method) || "PUT".equals(method)) {
            String contentLength = requestContext.getHeaderString("Content-Length");
            if (!(contentLength != null && Long.parseLong(contentLength) >= 100000L || "PUT".equals(method))) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)requestContext.getEntityStream(), (OutputStream)bytes);
                String body = bytes.toString("UTF-8");
                int length = Math.min(body.length(), 2000);
                boolean truncated = length < body.length();
                MDC.put((String)"body", (String)("\n" + body.substring(0, length) + (truncated ? "(TRUNCATED, total " + bytes.toByteArray().length + " bytes))" : "")));
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes.toByteArray()));
            } else {
                MDC.put((String)"body", (String)("\n" + contentLength + " bytes"));
            }
        }
    }
}

