/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.swagger;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import nl.vpro.jackson2.JsonFilter;
import nl.vpro.swagger.SwaggerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(SwaggerFilter.class);
    private static ExecutorService executor = Executors.newCachedThreadPool();

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String accept;
        HttpServletRequest req = (HttpServletRequest)request;
        if (!req.getPathInfo().endsWith(".json") && (accept = req.getHeader("accept")) != null) {
            boolean json = false;
            try {
                String[] mtypes;
                for (String mtype : mtypes = accept.split(";", 2)[0].split(",")) {
                    if (!MediaType.valueOf((String)mtype).isCompatible(MediaType.APPLICATION_JSON_TYPE)) continue;
                    json = true;
                    break;
                }
            }
            catch (Exception e) {
                LOG.warn(e.getMessage());
            }
            if (!json) {
                LOG.debug("Not json");
                chain.doFilter(request, response);
                return;
            }
        }
        String[] scheme = req.getHeader("X-Forwarded-Proto");
        long serverPort = req.getServerPort();
        if (scheme == null) {
            scheme = req.getScheme();
        } else {
            switch (scheme) {
                case "http": {
                    serverPort = 80L;
                    break;
                }
                case "https": {
                    serverPort = 443L;
                }
            }
        }
        StringBuilder newValue = new StringBuilder((String)scheme);
        newValue.append("://").append(req.getServerName());
        if (scheme.equals("http") && serverPort != 80L || scheme.equals("https") && serverPort != 443L) {
            newValue.append(':').append(serverPort);
        }
        newValue.append(req.getContextPath()).append("/api");
        JsonFilter.Replacement replacement = new JsonFilter.Replacement("basePath", (Object)"${api.basePath}", (Object)newValue.toString());
        List<JsonFilter.Replacement> replacements = Collections.singletonList(replacement);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        OutputStream out = this.transform((OutputStream)servletOutputStream, replacements);
        1 wrapped = new /* Unavailable Anonymous Inner Class!! */;
        chain.doFilter(request, (ServletResponse)wrapped);
        out.close();
    }

    public void destroy() {
        executor.shutdownNow();
    }

    public OutputStream transform(OutputStream from, List<JsonFilter.Replacement> replacements) throws IOException {
        PipedInputStream in = new PipedInputStream();
        Future[] future = new Future[1];
        2 out = new /* Unavailable Anonymous Inner Class!! */;
        JsonFilter filter = new JsonFilter((InputStream)in, from, replacements);
        future[0] = executor.submit(filter);
        return out;
    }
}

