/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.jupiter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import nl.vpro.test.jupiter.ExceptionCollector;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortOnException
extends ExceptionCollector
implements InvocationInterceptor,
BeforeAllCallback {
    private static final Logger log = LoggerFactory.getLogger(AbortOnException.class);
    protected boolean active = true;

    public void beforeAll(ExtensionContext context) {
        TestMethodOrder annotation = context.getRequiredTestClass().getAnnotation(TestMethodOrder.class);
        OnlyIfOrdered onlyIfOrdered = context.getRequiredTestClass().getAnnotation(OnlyIfOrdered.class);
        if (annotation == null || annotation.value().equals(MethodOrderer.Random.class)) {
            if (onlyIfOrdered == null) {
                throw new IllegalStateException("The abort on exception extension only makes sense with ordered test methods");
            }
            log.info("Tests are not ordered. Disabled AbortOnException extension");
            this.active = false;
        }
    }

    @Override
    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        if (this.active) {
            boolean skip;
            boolean hasNoAbortAnnotation = ((Method)invocationContext.getExecutable()).getAnnotation(NoAbort.class) != null;
            boolean bl = skip = !hasNoAbortAnnotation && !this.fails.isEmpty();
            if (skip) {
                throw new TestAbortedException("An exception occured already " + ((Method)((ExceptionCollector.Fail)this.fails.get(0)).getInvocationContext().getExecutable()).getName());
            }
        }
        super.interceptTestMethod(invocation, invocationContext, extensionContext);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface OnlyIfOrdered {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NoAbort {
        public String value() default "";
    }
}

