/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.util.jackson2;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nl.vpro.jackson2.Jackson2Mapper;
import nl.vpro.test.util.TestClass;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson2TestUtil {
    private static final Logger log = LoggerFactory.getLogger(Jackson2TestUtil.class);
    private static final ObjectMapper MAPPER = Jackson2Mapper.getPrettyStrictInstance();

    public static void assertJsonEquals(String pref, CharSequence expected, CharSequence actual) {
        try {
            JSONAssert.assertEquals((String)(pref + "\n" + actual + "\nis different from expected\n" + expected), (String)String.valueOf(expected), (String)String.valueOf(actual), (JSONCompareMode)JSONCompareMode.STRICT);
        }
        catch (AssertionError fail) {
            log.info(((Throwable)((Object)fail)).getMessage());
            Assertions.assertThat((CharSequence)Jackson2TestUtil.prettify(actual)).isEqualTo((Object)Jackson2TestUtil.prettify(expected));
        }
        catch (JSONException e) {
            log.error(e.getMessage());
            Jackson2TestUtil.assertThatJson(actual).isEqualTo(Jackson2TestUtil.prettify(expected));
        }
    }

    public static CharSequence prettify(CharSequence test) {
        if (test == null) {
            return null;
        }
        try {
            JsonNode jsonNode = MAPPER.readTree(String.valueOf(test));
            String pretty = MAPPER.writeValueAsString((Object)jsonNode);
            return pretty;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertJsonEquals(CharSequence expected, CharSequence actual) {
        Jackson2TestUtil.assertJsonEquals("", expected, actual);
    }

    public static <T> T roundTrip(T input) throws Exception {
        return Jackson2TestUtil.roundTrip(input, "");
    }

    public static <T> T roundTrip(T input, String contains) throws Exception {
        StringWriter writer = new StringWriter();
        MAPPER.writeValue((Writer)writer, input);
        String text = writer.toString();
        if (StringUtils.isNotEmpty((CharSequence)contains)) {
            Assertions.assertThat((String)text).contains(new CharSequence[]{contains});
        }
        return (T)MAPPER.readValue(text, input.getClass());
    }

    public static <T> T roundTripAndSimilar(T input, String expected) {
        return Jackson2TestUtil.roundTripAndSimilar(MAPPER, input, expected);
    }

    public static <T> T roundTripAndSimilar(T input, JsonNode expected) throws Exception {
        return Jackson2TestUtil.roundTripAndSimilar(MAPPER, input, expected);
    }

    public static <T> T roundTripAndSimilar(ObjectMapper mapper, T input, String expected) {
        return Jackson2TestUtil.roundTripAndSimilar(mapper, input, expected, mapper.getTypeFactory().constructType(input.getClass()));
    }

    public static <T> T roundTripAndSimilar(ObjectMapper mapper, T input, JsonNode expected) throws Exception {
        return Jackson2TestUtil.roundTripAndSimilar(mapper, input, expected, mapper.getTypeFactory().constructType(input.getClass()));
    }

    public static <T> T roundTripAndSimilar(ObjectMapper mapper, T input, InputStream expected) throws Exception {
        StringWriter write = new StringWriter();
        IOUtils.copy((InputStream)expected, (Writer)write, (String)"UTF-8");
        return Jackson2TestUtil.roundTripAndSimilar(mapper, input, write.toString());
    }

    public static <T> T roundTripAndSimilarAndEquals(T input, String expected) {
        T result = Jackson2TestUtil.roundTripAndSimilar(input, expected);
        Assertions.assertThat(result).isEqualTo(input);
        return result;
    }

    public static <T> T roundTripAndSimilarAndEquals(T input, JsonNode expected) throws Exception {
        T result = Jackson2TestUtil.roundTripAndSimilar(input, expected);
        Assertions.assertThat(result).isEqualTo(input);
        return result;
    }

    public static <T> T roundTripAndSimilarAndEquals(ObjectMapper mapper, T input, String expected) {
        T result = Jackson2TestUtil.roundTripAndSimilar(mapper, input, expected);
        Assertions.assertThat(result).isEqualTo(input);
        return result;
    }

    public static <T> T assertJsonEquals(String actual, String expected, Class<T> typeReference) throws IOException {
        Jackson2TestUtil.assertJsonEquals("", (CharSequence)expected, actual);
        return (T)MAPPER.readValue(actual, typeReference);
    }

    protected static <T> T roundTripAndSimilar(T input, String expected, JavaType typeReference) {
        return Jackson2TestUtil.roundTripAndSimilar(MAPPER, input, expected, typeReference);
    }

    protected static <T> T roundTripAndSimilar(ObjectMapper mapper, T input, String expected, JavaType typeReference) {
        StringWriter originalWriter = new StringWriter();
        mapper.writeValue((Writer)originalWriter, input);
        String marshalled = originalWriter.toString();
        log.debug("Comparing {} with expected {}", (Object)marshalled, (Object)expected);
        Jackson2TestUtil.assertJsonEquals(expected, marshalled);
        Object unmarshalled = mapper.readValue(marshalled, typeReference);
        StringWriter remarshal = new StringWriter();
        mapper.writeValue((Writer)remarshal, unmarshalled);
        String remarshalled = remarshal.toString();
        log.debug("Comparing {} with expected {}", (Object)remarshalled, (Object)expected);
        Jackson2TestUtil.assertJsonEquals("REMARSHALLED", (CharSequence)expected, remarshalled);
        return (T)unmarshalled;
    }

    protected static <T> T roundTripAndSimilar(ObjectMapper mapper, T input, JsonNode expected, JavaType typeReference) throws Exception {
        return Jackson2TestUtil.roundTripAndSimilar(mapper, input, mapper.writeValueAsString((Object)expected), typeReference);
    }

    public static <T> T roundTripAndSimilarValue(T input, String expected) {
        TestClass<T> embed = new TestClass<T>(input);
        JavaType type = Jackson2Mapper.getInstance().getTypeFactory().constructParametricType(TestClass.class, new Class[]{input.getClass()});
        TestClass<T> result = Jackson2TestUtil.roundTripAndSimilar(embed, "{\"value\": " + expected + "}", type);
        return result.value;
    }

    public static <S extends JsonObjectAssert<S, T>, T> JsonObjectAssert<S, T> assertThatJson(T o) {
        return new JsonObjectAssert(o);
    }

    public static <S extends JsonObjectAssert<S, T>, T> JsonObjectAssert<S, T> assertThatJson(ObjectMapper mapper, T o) {
        return new JsonObjectAssert(mapper, o);
    }

    public static <S extends JsonObjectAssert<S, T>, T> JsonObjectAssert<S, T> assertThatJson(Class<T> o, String value) {
        return new JsonObjectAssert(o, value);
    }

    public static <S extends JsonObjectAssert<S, T>, T> JsonObjectAssert<S, T> assertThatJson(ObjectMapper mapper, Class<T> o, String value) {
        return new JsonObjectAssert(mapper, o, value);
    }

    public static JsonStringAssert assertThatJson(String o) {
        return new JsonStringAssert(o);
    }

    public static class JsonStringAssert
    extends AbstractObjectAssert<JsonStringAssert, CharSequence> {
        protected JsonStringAssert(CharSequence actual) {
            super((Object)actual, JsonStringAssert.class);
        }

        public JsonStringAssert isSimilarTo(String expected) {
            Jackson2TestUtil.assertJsonEquals("", (CharSequence)expected, (CharSequence)this.actual);
            return (JsonStringAssert)this.myself;
        }

        public JsonStringAssert isSimilarToResource(String resource) {
            try {
                String expected = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resource), (Charset)StandardCharsets.UTF_8);
                return this.isSimilarTo(expected);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static class JsonObjectAssert<S extends JsonObjectAssert<S, A>, A>
    extends AbstractObjectAssert<S, A> {
        A rounded;
        private final ObjectMapper mapper;

        protected JsonObjectAssert(A actual) {
            super(actual, JsonObjectAssert.class);
            this.mapper = MAPPER;
        }

        protected JsonObjectAssert(Class<A> actual, String string) {
            super(JsonObjectAssert.read(MAPPER, actual, string), JsonObjectAssert.class);
            this.mapper = MAPPER;
        }

        protected JsonObjectAssert(ObjectMapper mapper, A actual) {
            super(actual, JsonObjectAssert.class);
            this.mapper = mapper;
        }

        protected JsonObjectAssert(ObjectMapper mapper, Class<A> actual, String string) {
            super(JsonObjectAssert.read(mapper, actual, string), JsonObjectAssert.class);
            this.mapper = mapper;
        }

        protected static <A> A read(ObjectMapper mapper, Class<A> actual, String string) {
            try {
                return (A)mapper.readValue(string, actual);
            }
            catch (IOException e) {
                Fail.fail((String)e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public S isSimilarTo(String expected) {
            try {
                this.rounded = Jackson2TestUtil.roundTripAndSimilar(this.mapper, this.actual, expected);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage(), (Throwable)e);
            }
            return (S)((Object)((JsonObjectAssert)this.myself));
        }

        public S isSimilarTo(JsonNode expected) {
            try {
                this.rounded = Jackson2TestUtil.roundTripAndSimilar(this.mapper, this.actual, expected);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage(), (Throwable)e);
            }
            return (S)((Object)((JsonObjectAssert)this.myself));
        }

        public AbstractObjectAssert<?, A> andRounded() {
            if (this.rounded == null) {
                throw new IllegalStateException("No similation was done already.");
            }
            return Assertions.assertThat(this.rounded);
        }

        public A get() {
            if (this.rounded == null) {
                throw new IllegalStateException("No similation was done already.");
            }
            return this.rounded;
        }
    }
}

