/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.util.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class SerializeTestUtil {
    public static <T> byte[] serialize(T object) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(object);
        out.close();
        return bytes.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(byte[] bytes, Class<T> clazz) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = in.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T roundTrip(T input) throws IOException {
        return (T)SerializeTestUtil.deserialize(SerializeTestUtil.serialize(input), input.getClass());
    }

    public static <T> T roundTripAndEquals(T input) throws IOException {
        Object newT = SerializeTestUtil.deserialize(SerializeTestUtil.serialize(input), input.getClass());
        Assertions.assertThat(newT).isEqualTo(input);
        return (T)newT;
    }

    public static <T> ObjectAssert assertThatSerialized(T o) {
        return new ObjectAssert(o);
    }

    public static class ObjectAssert<S extends ObjectAssert<S, A>, A>
    extends AbstractObjectAssert<S, A> {
        A rounded;

        protected ObjectAssert(A actual) {
            super(actual, ObjectAssert.class);
        }

        public AbstractObjectAssert<?, A> andRounded() throws IOException {
            if (this.rounded == null) {
                this.rounded = SerializeTestUtil.roundTrip(this.actual);
            }
            return Assertions.assertThat(this.rounded);
        }

        public A get() throws IOException {
            if (this.rounded == null) {
                this.rounded = SerializeTestUtil.roundTrip(this.actual);
            }
            return this.rounded;
        }
    }
}

