/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.jupiter;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.opentest4j.IncompleteExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionCollector
implements InvocationInterceptor,
ParameterResolver {
    private static final Logger log = LoggerFactory.getLogger(ExceptionCollector.class);
    List<Fail> fails = new ArrayList<Fail>();

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        try {
            invocation.proceed();
        }
        catch (IncompleteExecutionException te) {
            log.debug("These kind of exceptions are used by junit itself to abort tests, and are not exception which should kind as failures.");
            throw te;
        }
        catch (Throwable e) {
            this.fails.add(new Fail(invocation, invocationContext, e));
            throw e;
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        boolean collection = parameterContext.getParameter().getType().isAssignableFrom(List.class);
        if (collection) {
            ParameterizedType type = (ParameterizedType)parameterContext.getParameter().getParameterizedType();
            return Throwable.class.isAssignableFrom((Class)type.getActualTypeArguments()[0]);
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.fails.stream().map(f -> ((Fail)f).exception).collect(Collectors.toList());
    }

    static class Fail {
        private final Throwable exception;
        private final ReflectiveInvocationContext<Method> invocationContext;
        private final InvocationInterceptor.Invocation<Void> invocation;

        Fail(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, Throwable exception) {
            this.invocation = invocation;
            this.invocationContext = invocationContext;
            this.exception = exception;
        }

        public Throwable getException() {
            return this.exception;
        }

        public ReflectiveInvocationContext<Method> getInvocationContext() {
            return this.invocationContext;
        }

        public InvocationInterceptor.Invocation<Void> getInvocation() {
            return this.invocation;
        }
    }
}

