/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.util.jaxb;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class AbstractSchemaTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaTest.class);
    private static final File DIR = Files.createTempDir();
    protected static JAXBContext context;

    @BeforeAll
    public static void generateXSDs() throws JAXBException, IOException {
        context = AbstractSchemaTest.generate(new Class[0]);
    }

    protected <T extends Enum<T>> void testEnum(String resource, String enumTypeName, Class<T> enumClass) {
        Enum[] values;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(this.getClass().getResourceAsStream(resource));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("/schema/simpleType[@name='" + enumTypeName + "']/restriction/enumeration", document, XPathConstants.NODESET);
        ArrayList<String> valuesInXsd = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            valuesInXsd.add(nodes.item(i).getAttributes().getNamedItem("value").getTextContent());
        }
        ArrayList<String> valuesInEnum = new ArrayList<String>();
        for (Enum v : values = (Enum[])enumClass.getEnumConstants()) {
            XmlEnumValue xmlEnumValue = enumClass.getField(v.name()).getAnnotation(XmlEnumValue.class);
            valuesInEnum.add(xmlEnumValue != null ? xmlEnumValue.value() : v.name());
        }
        Assertions.assertThat(valuesInXsd).containsExactlyInAnyOrderElementsOf(valuesInEnum);
    }

    private static File getFile(String namespace) {
        String filename = namespace.replaceAll("/", "_");
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            filename = "absentnamespace";
        }
        return new File(DIR, filename + ".xsd");
    }

    protected void testNamespace(String namespace) throws IOException {
        File file = AbstractSchemaTest.getFile(namespace);
        InputStream control = this.getClass().getResourceAsStream("/schema/" + file.getName());
        if (control == null) {
            System.out.println(file.getName());
            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)System.out);
            throw new RuntimeException("No file " + file.getName());
        }
        Diff diff = DiffBuilder.compare((Object)control).withTest((Object)file).checkForIdentical().build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)diff.hasDifferences()).withFailMessage("" + file + " should be equal to " + this.getClass().getResource("/schema/" + file.getName()) + ":\n" + Stream.of(diff.getDifferences()).map(Object::toString).collect(Collectors.joining("\n")) + "\n\n" + AbstractSchemaTest.differences(Arrays.asList(IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8).split("\n")), Arrays.asList(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/schema/" + file.getName()), (Charset)StandardCharsets.UTF_8).split("\n"))), new Object[0])).isFalse();
    }

    static String differences(List<String> first, List<String> second) {
        Patch patch = DiffUtils.diff(first, second);
        return patch.getDeltas().stream().map(Object::toString).collect(Collectors.joining("\n"));
    }

    public static JAXBContext generate(Class<?> ... classes) throws JAXBException, IOException {
        JAXBContext context = JAXBContext.newInstance((Class[])classes);
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
                    return null;
                }
                File f = AbstractSchemaTest.getFile(namespaceUri);
                if (f.exists()) {
                    f = File.createTempFile(namespaceUri, "");
                }
                log.info(namespaceUri + " -> " + f);
                StreamResult result = new StreamResult(f);
                result.setSystemId(f);
                FileOutputStream fo = new FileOutputStream(f);
                result.setOutputStream(fo);
                return result;
            }
        });
        return context;
    }
}

