/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.theory;

import nl.vpro.test.theory.ObjectTest;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.experimental.theories.Theory;

public abstract class ComparableTest<S extends Comparable<S>>
extends ObjectTest<S> {
    @Theory
    public final <I> void equalsConsistentWithComparable(Comparable x, Object y) {
        Assume.assumeNotNull((Object[])new Object[]{x});
        Assume.assumeNotNull((Object[])new Object[]{y});
        Assertions.assertThat((x.compareTo(y) == 0 ? 1 : 0) != 0).isEqualTo(x.equals(y));
    }

    @Theory
    public final void compareToNull(Comparable<?> x) {
        Assume.assumeNotNull((Object[])new Object[]{x});
        try {
            x.compareTo(null);
            Assert.fail((String)"Compare to null should throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

