/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.jqwik;

import net.jqwik.api.Assume;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import nl.vpro.test.jqwik.BasicObjectTest;
import org.assertj.core.api.Assertions;

public interface ComparableTest<E extends Comparable<E>>
extends BasicObjectTest<E> {
    @Property
    default public void equalsConsistentWithComparable(@ForAll(value="datapoints") E x, @ForAll(value="datapoints") E y) {
        Assume.that((x != null ? 1 : 0) != 0);
        Assume.that((y != null ? 1 : 0) != 0);
        Assertions.assertThat((x.compareTo(y) == 0 ? 1 : 0) != 0).isEqualTo(x.equals(y));
    }

    @Property
    default public void compareToNull(@ForAll(value="datapoints") E x) {
        Assume.that((x != null ? 1 : 0) != 0);
        Assertions.assertThatThrownBy(() -> x.compareTo(null)).isInstanceOf(NullPointerException.class);
    }
}

