/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.theory;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@Ignore
@RunWith(value=Theories.class)
public abstract class ObjectTest<T> {
    @Theory
    public final void equalsIsReflexive(Object x) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assert.assertThat((Object)x.equals(x), (Matcher)CoreMatchers.is((Object)true));
    }

    @Theory
    public final void equalsIsSymmetric(Object x, Object y) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assume.assumeThat((Object)y, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assume.assumeThat((Object)y.equals(x), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)x.equals(y), (Matcher)CoreMatchers.is((Object)true));
    }

    @Theory
    public final void equalsIsTransitive(Object x, Object y, Object z) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assume.assumeThat((Object)y, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assume.assumeThat((Object)z, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assume.assumeThat((Object)(x.equals(y) && y.equals(z) ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)z.equals(x), (Matcher)CoreMatchers.is((Object)true));
    }

    @Theory
    public final void equalsIsConsistent(Object x, Object y) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        boolean alwaysTheSame = x.equals(y);
        for (int i = 0; i < 30; ++i) {
            Assert.assertThat((Object)x.equals(y), (Matcher)CoreMatchers.is((Object)alwaysTheSame));
        }
    }

    @Theory
    public final void equalsReturnFalseOnNull(Object x) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assert.assertThat((Object)x.equals(null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Theory
    public final void hashCodeIsSelfConsistent(Object x) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        int alwaysTheSame = x.hashCode();
        for (int i = 0; i < 30; ++i) {
            Assert.assertThat((Object)x.hashCode(), (Matcher)CoreMatchers.is((Object)alwaysTheSame));
        }
    }

    @Theory
    public final void hashCodeIsConsistentWithEquals(Object x, Object y) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assume.assumeThat((Object)x.equals(y), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)x.hashCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)y.hashCode())));
    }

    @Theory
    public final void equalsWorks(Object x, Object y) {
        Assume.assumeThat((Object)x, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null))));
        Assume.assumeThat((Object)(x == y ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)x.equals(y), (Matcher)CoreMatchers.is((Object)true));
    }
}

