/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.jqwik;

import java.util.ArrayList;
import java.util.Objects;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import nl.vpro.util.Pair;
import org.assertj.core.api.Assertions;

public interface BasicObjectTest<E> {
    public static final String DATAPOINTS = "datapoints";
    public static final String NONNULL_DATAPOINTS = "nonNullDatapoints";
    public static final String EQUAL_DATAPOINTS = "equalDatapoints";

    @Property
    default public void equalsIsReflexive(@ForAll(value="nonNullDatapoints") E x) {
        Assertions.assertThat((boolean)x.equals(x)).isTrue();
    }

    @Property
    default public void equalsIsSymmetric(@ForAll(value="nonNullDatapoints") E x, @ForAll(value="nonNullDatapoints") E y) {
        Assertions.assertThat((boolean)x.equals(y)).isEqualTo(y.equals(x));
    }

    @Property
    default public void equalsIsTransitive(@ForAll(value="equalDatapoints") Pair<E, E> p1, @ForAll(value="equalDatapoints") Pair<E, E> p2) {
        Assertions.assertThat((boolean)p1.getFirst().equals(p2.getSecond())).isEqualTo(p1.getSecond().equals(p2.getFirst()));
    }

    @Property
    default public void equalsIsConsistent(@ForAll(value="nonNullDatapoints") E x, @ForAll(value="datapoints") E y) {
        boolean alwaysTheSame = x.equals(y);
        for (int i = 0; i < 30; ++i) {
            Assertions.assertThat((boolean)x.equals(y)).isEqualTo(alwaysTheSame);
        }
    }

    @Property
    default public void equalsReturnFalseOnNull(@ForAll(value="nonNullDatapoints") E x) {
        Assertions.assertThat((boolean)x.equals(null)).isFalse();
    }

    @Property
    default public void hashCodeIsSelfConsistent(@ForAll(value="nonNullDatapoints") E x) {
        int alwaysTheSame = x.hashCode();
        for (int i = 0; i < 30; ++i) {
            Assertions.assertThat((int)x.hashCode()).isEqualTo(alwaysTheSame);
        }
    }

    @Property
    default public void hashCodeIsConsistentWithEquals(@ForAll(value="equalDatapoints") Pair<E, E> pair) {
        Assertions.assertThat((int)pair.getFirst().hashCode()).isEqualTo(pair.getSecond().hashCode());
    }

    @Property
    default public void toString(@ForAll(value="nonNullDatapoints") E object) {
        Assertions.assertThatNoException().isThrownBy(object::toString);
    }

    @Provide
    public Arbitrary<? extends E> datapoints();

    @Provide
    default public Arbitrary<? extends Pair<E, E>> equalDatapoints() {
        ArrayList pairs = new ArrayList();
        this.datapoints().forEachValue(x -> this.datapoints().forEachValue(y -> {
            if (x != null && x.equals(y)) {
                pairs.add(Pair.of((Object)x, (Object)y));
            }
        }));
        return Arbitraries.of(pairs);
    }

    @Provide
    default public Arbitrary<? extends E> nonNullDatapoints() {
        return this.datapoints().filter(Objects::nonNull);
    }
}

