/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.jqwik;

import net.jqwik.api.Assume;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import nl.vpro.test.jqwik.BasicObjectTest;
import nl.vpro.util.Pair;
import org.assertj.core.api.Assertions;

public interface ComparableTest<E extends Comparable<E>>
extends BasicObjectTest<E> {
    @Property
    default public void equalsConsistentWithComparable(@ForAll(value="equalDatapoints") Pair<E, E> pair) {
        Assertions.assertThat((int)((Comparable)pair.getFirst()).compareTo(pair.getSecond())).isEqualTo(0);
    }

    @Property
    default public void compareToNull(@ForAll(value="nonNullDatapoints") E x) {
        Assertions.assertThatThrownBy(() -> x.compareTo(null)).isInstanceOf(NullPointerException.class);
    }

    @Property
    default public void compareToIsAntiCommutative(@ForAll(value="nonNullDatapoints") E x, @ForAll(value="nonNullDatapoints") E y) {
        Assertions.assertThat((int)Integer.signum(x.compareTo(y))).isEqualTo(-1 * Integer.signum(y.compareTo(x)));
    }

    @Property(maxDiscardRatio=1000)
    default public void compareToIsTransitiveBigger(@ForAll(value="nonNullDatapoints") E x, @ForAll(value="nonNullDatapoints") E y, @ForAll(value="nonNullDatapoints") E z) {
        Assume.that((x.compareTo(y) > 0 ? 1 : 0) != 0);
        Assume.that((y.compareTo(z) > 0 ? 1 : 0) != 0);
        Assertions.assertThat((int)x.compareTo(z)).isGreaterThan(0);
    }

    @Property(maxDiscardRatio=1000)
    default public void compareToIsTransitiveSmaller(@ForAll(value="nonNullDatapoints") E x, @ForAll(value="nonNullDatapoints") E y, @ForAll(value="nonNullDatapoints") E z) {
        Assume.that((x.compareTo(y) < 0 ? 1 : 0) != 0);
        Assume.that((y.compareTo(z) < 0 ? 1 : 0) != 0);
        Assertions.assertThat((int)x.compareTo(z)).isLessThan(0);
    }

    @Property(maxDiscardRatio=1000)
    default public void compareToIsTransitiveEquals(@ForAll(value="nonNullDatapoints") E x, @ForAll(value="nonNullDatapoints") E y, @ForAll(value="nonNullDatapoints") E z) {
        Assume.that((x.compareTo(y) == 0 ? 1 : 0) != 0);
        Assume.that((y.compareTo(z) == 0 ? 1 : 0) != 0);
        Assertions.assertThat((int)x.compareTo(z)).isEqualTo(0);
    }
}

