/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.util.jackson2;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.json.test.JSONAssert;
import nl.vpro.jackson2.Jackson2Mapper;
import nl.vpro.test.util.TestClass;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson2TestUtil {
    private static final Logger log = LoggerFactory.getLogger(Jackson2TestUtil.class);
    private static final ObjectMapper MAPPER = Jackson2Mapper.getPrettyInstance();

    public static <T> T roundTrip(T input) throws Exception {
        return Jackson2TestUtil.roundTrip(input, "");
    }

    public static <T> T roundTrip(T input, String contains) throws Exception {
        StringWriter writer = new StringWriter();
        MAPPER.writeValue((Writer)writer, input);
        String text = writer.toString();
        if (StringUtils.isNotEmpty((CharSequence)contains)) {
            Assertions.assertThat((String)text).contains(new CharSequence[]{contains});
        }
        return (T)MAPPER.readValue(text, input.getClass());
    }

    public static <T> T roundTripAndSimilar(T input, String expected) throws Exception {
        return Jackson2TestUtil.roundTripAndSimilar(MAPPER, input, expected);
    }

    public static <T> T roundTripAndSimilar(ObjectMapper mapper, T input, String expected) throws Exception {
        return Jackson2TestUtil.roundTripAndSimilar(mapper, input, expected, mapper.getTypeFactory().constructType(input.getClass()));
    }

    public static <T> T roundTripAndSimilarAndEquals(T input, String expected) throws Exception {
        T result = Jackson2TestUtil.roundTripAndSimilar(input, expected);
        Assertions.assertThat(result).isEqualTo(input);
        return result;
    }

    public static <T> T roundTripAndSimilarAndEquals(ObjectMapper mapper, T input, String expected) throws Exception {
        T result = Jackson2TestUtil.roundTripAndSimilar(mapper, input, expected);
        Assertions.assertThat(result).isEqualTo(input);
        return result;
    }

    public static <T> T assertJsonEquals(String text, String expected, Class<T> typeReference) throws IOException {
        JSONAssert.assertJsonEquals((String)("\n" + text + "\nis different from expected\n" + expected), (String)expected, (String)text);
        return (T)MAPPER.readValue(text, typeReference);
    }

    protected static <T> T roundTripAndSimilar(T input, String expected, JavaType typeReference) throws Exception {
        return Jackson2TestUtil.roundTripAndSimilar(MAPPER, input, expected, typeReference);
    }

    protected static <T> T roundTripAndSimilar(ObjectMapper mapper, T input, String expected, JavaType typeReference) throws Exception {
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, input);
        String text = writer.toString();
        log.debug("Comparing {} with expected {}", (Object)text, (Object)expected);
        JSONAssert.assertJsonEquals((String)("\n" + text + "\nis different from expected\n" + expected), (String)expected, (String)text);
        return (T)mapper.readValue(text, typeReference);
    }

    public static <T> T roundTripAndSimilarValue(T input, String expected) throws Exception {
        TestClass<T> embed = new TestClass<T>(input);
        JavaType type = Jackson2Mapper.getInstance().getTypeFactory().constructParametricType(TestClass.class, new Class[]{input.getClass()});
        TestClass<T> result = Jackson2TestUtil.roundTripAndSimilar(embed, "{\"value\": " + expected + "}", type);
        return result.value;
    }

    public static <S extends JsonObjectAssert<S, T>, T> JsonObjectAssert<S, T> assertThatJson(T o) {
        return new JsonObjectAssert(o);
    }

    public static <S extends JsonObjectAssert<S, T>, T> JsonObjectAssert<S, T> assertThatJson(Class<T> o, String value) {
        return new JsonObjectAssert(o, value);
    }

    public static JsonStringAssert assertThatJson(String o) {
        return new JsonStringAssert(o);
    }

    public static class JsonStringAssert
    extends AbstractObjectAssert<JsonStringAssert, CharSequence> {
        protected JsonStringAssert(CharSequence actual) {
            super((Object)actual, JsonStringAssert.class);
        }

        public JsonStringAssert isSimilarTo(String expected) {
            JSONAssert.assertJsonEquals((String)("\n" + this.actual + "\nis different from expected\n" + expected), (String)expected, (String)String.valueOf(this.actual));
            return (JsonStringAssert)this.myself;
        }
    }

    public static class JsonObjectAssert<S extends JsonObjectAssert<S, A>, A>
    extends AbstractObjectAssert<S, A> {
        A rounded;

        protected JsonObjectAssert(A actual) {
            super(actual, JsonObjectAssert.class);
        }

        protected JsonObjectAssert(Class<A> actual, String string) {
            super(JsonObjectAssert.read(actual, string), JsonObjectAssert.class);
        }

        protected static <A> A read(Class<A> actual, String string) {
            try {
                return (A)MAPPER.readValue(string, actual);
            }
            catch (IOException e) {
                Fail.fail((String)e.getMessage());
                return null;
            }
        }

        public S isSimilarTo(String expected) {
            try {
                this.rounded = Jackson2TestUtil.roundTripAndSimilar(this.actual, expected);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage());
            }
            return (S)((Object)((JsonObjectAssert)this.myself));
        }

        public AbstractObjectAssert<?, A> andRounded() {
            if (this.rounded == null) {
                throw new IllegalStateException("No similation was done already.");
            }
            return Assertions.assertThat(this.rounded);
        }

        public A get() {
            if (this.rounded == null) {
                throw new IllegalStateException("No similation was done already.");
            }
            return this.rounded;
        }
    }
}

