/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.test.util.jaxb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.ComparisonFailure;
import nl.vpro.test.util.TestClass;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;

public class JAXBTestUtil {
    private static final String LOCAL_URI = "uri:local";
    public static Consumer<DiffBuilder> IGNORE_ELEMENT_ORDER = df -> df.withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndText}));

    public static <T> String marshal(T object) {
        StringWriter writer = new StringWriter();
        JAXBTestUtil.marshal(object, (Object o) -> JAXB.marshal((Object)o, (Writer)writer));
        return writer.toString();
    }

    public static <T> Element marshalToElement(T object) {
        DOMResult writer = new DOMResult();
        JAXBTestUtil.marshal(object, (Object o) -> JAXB.marshal((Object)o, (Result)writer));
        return ((Document)writer.getNode()).getDocumentElement();
    }

    private static <T> void marshal(T object, Consumer<Object> marshaller) {
        XmlRootElement xmlRootElementAnnotation = object.getClass().getAnnotation(XmlRootElement.class);
        if (xmlRootElementAnnotation == null) {
            Class<?> clazz = object.getClass();
            String tagName = clazz.getSimpleName();
            if (tagName.length() == 1 || Character.isUpperCase(tagName.charAt(0)) && !Character.isUpperCase(tagName.charAt(1))) {
                tagName = Character.toLowerCase(tagName.charAt(0)) + tagName.substring(1);
            }
            marshaller.accept(new JAXBElement(new QName(LOCAL_URI, tagName, "local"), clazz, object));
        } else {
            marshaller.accept(object);
        }
    }

    private static Marshaller getMarshallerForUnknownClasses(Class<?> ... clazz) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])clazz);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    private static String marshal(Marshaller marshaller, Object o) throws JAXBException {
        StringWriter writer = new StringWriter();
        marshaller.marshal(o, (Writer)writer);
        return writer.toString();
    }

    public static <T> T unmarshal(String xml, Class<? extends T> clazz) {
        return (T)JAXB.unmarshal((Reader)new StringReader(xml), clazz);
    }

    public static <T> T roundTrip(T input) {
        return (T)JAXB.unmarshal((Reader)new StringReader(JAXBTestUtil.marshal(input)), input.getClass());
    }

    @Deprecated
    public static <T> T roundTrip(T input, String contains) {
        String xml = JAXBTestUtil.marshal(input);
        Assertions.assertThat((String)xml).contains(new CharSequence[]{contains});
        return (T)JAXB.unmarshal((Reader)new StringReader(xml), input.getClass());
    }

    public static <T> T roundTripContains(T input, boolean namespaceAware, String ... contains) {
        Element xml = JAXBTestUtil.marshalToElement(input);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        List elementsToFind = Arrays.stream(contains).map(cont -> {
            try {
                Element elementToFind = builder.parse(new InputSource(new StringReader((String)cont))).getDocumentElement();
                elementToFind.normalize();
                return elementToFind;
            }
            catch (IOException | SAXException se) {
                throw new RuntimeException(se);
            }
        }).collect(Collectors.toList());
        for (Element elementToFind : elementsToFind) {
            NodeList elementsByTagName = xml.getElementsByTagName(elementToFind.getTagName());
            boolean found = false;
            ArrayList<Diff> diffs = new ArrayList<Diff>();
            for (int i = 0; i < elementsByTagName.getLength(); ++i) {
                Node element = elementsByTagName.item(i);
                element.normalize();
                Diff diff = DiffBuilder.compare((Object)elementToFind).withTest((Object)element).ignoreWhitespace().checkForSimilar().build();
                diffs.add(diff);
                if (diff.hasDifferences()) continue;
                found = true;
            }
            if (found) continue;
            StringBuilderWriter writer = new StringBuilderWriter();
            JAXB.marshal(input, (Writer)writer);
            Assertions.assertThat((String)writer.toString()).contains((CharSequence[])contains);
        }
        return (T)JAXB.unmarshal((Source)new DOMSource(xml), input.getClass());
    }

    public static <T> T roundTripContains(T input, String ... contains) {
        return JAXBTestUtil.roundTripContains(input, true, contains);
    }

    @SafeVarargs
    public static <T> T roundTripAndSimilar(String input, Class<? extends T> inputClazz, Consumer<DiffBuilder> ... build) throws IOException, SAXException {
        try {
            T result = JAXBTestUtil.unmarshal(input, inputClazz);
            String xmlAfter = JAXBTestUtil.marshal(result);
            JAXBTestUtil.similar(xmlAfter, input, build);
            return result;
        }
        catch (SAXParseException spe) {
            throw new RuntimeException("input: " + input, spe);
        }
    }

    public static <T> T roundTripAndSimilar(InputStream input, Class<? extends T> inputClazz, Consumer<DiffBuilder> ... build) throws IOException, SAXException {
        StringWriter write = new StringWriter();
        IOUtils.copy((InputStream)input, (Writer)write, (String)"UTF-8");
        return JAXBTestUtil.roundTripAndSimilar(write.toString(), inputClazz, build);
    }

    public static <T> T roundTripAndSimilar(T input, String expected) throws IOException, SAXException {
        String xml = null;
        try {
            xml = JAXBTestUtil.marshal(input);
            JAXBTestUtil.similar(xml, expected, new Consumer[0]);
            Class<?> clazz = input.getClass();
            Object result = JAXBTestUtil.unmarshal(xml, clazz);
            String xmlAfter = JAXBTestUtil.marshal(result);
            JAXBTestUtil.similar(xmlAfter, xml, new Consumer[0]);
            return (T)result;
        }
        catch (SAXParseException spe) {
            throw new RuntimeException("input: " + xml + "\nexpected: " + expected, spe);
        }
    }

    public static <T> T roundTripAndValidateAndSimilar(T input, URL xsd, String expected) throws IOException, SAXException {
        String xml = null;
        try {
            xml = JAXBTestUtil.marshal(input);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsd);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xml)));
            JAXBTestUtil.similar(xml, expected, new Consumer[0]);
            Class<?> clazz = input.getClass();
            Object result = JAXBTestUtil.unmarshal(xml, clazz);
            String xmlAfter = JAXBTestUtil.marshal(result);
            JAXBTestUtil.similar(xmlAfter, xml, new Consumer[0]);
            return (T)result;
        }
        catch (SAXParseException spe) {
            throw new RuntimeException("input: " + xml + "\nexpected: " + expected, spe);
        }
    }

    public static <T> T roundTripAndSimilar(T input, InputStream expected) throws IOException, SAXException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)expected, (Writer)writer, (Charset)Charset.forName("UTF-8"));
        return JAXBTestUtil.roundTripAndSimilar(input, writer.toString());
    }

    public static <T> T roundTripAndSimilarAndEquals(T input, String expected) throws Exception {
        T result = JAXBTestUtil.roundTripAndSimilar(input, expected);
        Assertions.assertThat(result).isEqualTo(input);
        return result;
    }

    public static <T> T roundTripAndSimilarValue(T input, String expected) throws IOException, SAXException, JAXBException {
        TestClass<T> embed = new TestClass<T>(input);
        String xml = null;
        try {
            Marshaller marshaller = JAXBTestUtil.getMarshallerForUnknownClasses(TestClass.class, input.getClass());
            xml = JAXBTestUtil.marshal(marshaller, embed);
            JAXBTestUtil.similar(xml, "<testclass>" + expected + "</testclass>", new Consumer[0]);
            TestClass result = (TestClass)JAXB.unmarshal((Reader)new StringReader(xml), embed.getClass());
            String xmlAfter = JAXBTestUtil.marshal(result);
            JAXBTestUtil.similar(xmlAfter, xml, new Consumer[0]);
            return result.value;
        }
        catch (SAXParseException spe) {
            throw new RuntimeException("input: " + xml + "\nexpected: " + expected, spe);
        }
    }

    public static void similar(String input, String expected, Consumer<DiffBuilder> ... build) throws IOException, SAXException {
        DiffBuilder builder = DiffBuilder.compare((Object)expected).withTest((Object)input).ignoreWhitespace().checkForSimilar();
        for (Consumer<DiffBuilder> b : build) {
            b.accept(builder);
        }
        try {
            Diff diff = builder.build();
            if (diff.hasDifferences()) {
                throw new ComparisonFailure(diff.toString(), expected, input);
            }
            Assertions.assertThat((boolean)diff.hasDifferences()).isFalse();
        }
        catch (XMLUnitException xue) {
            throw new ComparisonFailure(xue.getMessage(), expected, input);
        }
    }

    public static <T> T similar(String input, String expected, Class<T> result) throws IOException, SAXException {
        JAXBTestUtil.similar(input, expected, new Consumer[0]);
        return JAXBTestUtil.unmarshal(input, result);
    }

    public static void similar(InputStream input, String expected) throws IOException, SAXException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Diff diff = DiffBuilder.compare((Object)expected).withTest((Object)input).ignoreComments().checkForSimilar().build();
        if (diff.hasDifferences()) {
            throw new ComparisonFailure(diff.toString(), expected, bytes.toString());
        }
    }

    public static void similar(InputStream input, InputStream expected) throws IOException, SAXException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)bytes);
        ByteArrayOutputStream expectedBytes = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)expected, (OutputStream)expectedBytes);
        Diff diff = DiffBuilder.compare((Object)expected).withTest((Object)input).checkForSimilar().build();
        if (diff.hasDifferences()) {
            throw new ComparisonFailure(diff.toString(), expectedBytes.toString(), bytes.toString());
        }
    }

    public static <S extends XMLObjectAssert<S, T>, T> XMLObjectAssert<S, T> assertThatXml(T o) {
        return new XMLObjectAssert(o);
    }

    public static XMLStringAssert assertThatXml(String o) {
        return new XMLStringAssert(o);
    }

    public static XMLStringAssert assertThatXml(ByteArrayOutputStream o) throws UnsupportedEncodingException {
        return JAXBTestUtil.assertThatXml(o.toByteArray());
    }

    public static XMLStringAssert assertThatXml(byte[] o) throws UnsupportedEncodingException {
        return new XMLStringAssert(new String(o, "UTF-8"));
    }

    public static class XMLStringAssert
    extends AbstractObjectAssert<XMLStringAssert, CharSequence> {
        protected XMLStringAssert(CharSequence actual) {
            super((Object)actual, XMLStringAssert.class);
        }

        public XMLStringAssert isSimilarTo(String expected) {
            try {
                JAXBTestUtil.similar(String.valueOf(this.actual), expected, new Consumer[0]);
            }
            catch (IOException | SAXException e) {
                Fail.fail((String)e.getMessage());
            }
            return (XMLStringAssert)this.myself;
        }
    }

    public static class XMLObjectAssert<S extends XMLObjectAssert<S, A>, A>
    extends AbstractObjectAssert<S, A> {
        A rounded;

        protected XMLObjectAssert(A actual) {
            super(actual, XMLObjectAssert.class);
        }

        public S isSimilarTo(String expected) {
            try {
                this.rounded = JAXBTestUtil.roundTripAndSimilar(this.actual, expected);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage(), (Throwable)e);
            }
            return (S)((Object)((XMLObjectAssert)this.myself));
        }

        public S containsSimilar(String expected) {
            try {
                this.rounded = JAXBTestUtil.roundTripContains(this.actual, expected);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage(), (Throwable)e);
            }
            return (S)((Object)((XMLObjectAssert)this.myself));
        }

        public AbstractObjectAssert<?, A> andRounded() {
            if (this.rounded == null) {
                throw new IllegalStateException("No similation was done already.");
            }
            return Assertions.assertThat(this.rounded);
        }

        public S isValid(Validator validator) throws SAXException, IOException {
            validator.validate(new StreamSource(new StringReader(JAXBTestUtil.marshal(this.rounded))));
            return (S)((Object)((XMLObjectAssert)this.myself));
        }

        public A get() {
            if (this.rounded == null) {
                throw new IllegalStateException("No similation was done already.");
            }
            return this.rounded;
        }
    }
}

