/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.apache.ws.security;

import javax.annotation.Resource;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.UsernameTokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;

public class PlainTextUsernameTokenValidator
extends UsernameTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PlainTextUsernameTokenValidator.class);
    @Resource(name="authenticationManager")
    AuthenticationManager manager;

    protected void verifyPlaintextPassword(UsernameToken usernameToken, RequestData data) {
        String name = usernameToken.getName();
        String password = usernameToken.getPassword();
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)name, (Object)password);
        try {
            authentication = this.manager.authenticate((Authentication)authentication);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        catch (AuthenticationException ae) {
            WSSecurityException e = new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, name + ":" + ae.getMessage());
            e.initCause((Throwable)ae);
            throw ae;
        }
        catch (RuntimeException t) {
            LOG.error(t.getMessage(), (Throwable)t);
            throw t;
        }
    }
}

