/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.xml.bind;

import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import lombok.Generated;
import nl.vpro.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationXmlAdapter
extends XmlAdapter<Duration, java.time.Duration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DurationXmlAdapter.class);
    static final DatatypeFactory DATATYPE_FACTORY;

    public java.time.Duration unmarshal(Duration xmlDurationValue) {
        if (xmlDurationValue != null) {
            String string = xmlDurationValue.getYears() > 0 ? "" + xmlDurationValue.getTimeInMillis(new Date(0L)) : xmlDurationValue.toString();
            try {
                return TimeUtils.parseDuration((CharSequence)string).orElseGet(() -> {
                    log.warn("Could not parse '" + string + "'");
                    return null;
                });
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new DateTimeParseException("Could not parse " + string + " to duration: " + dateTimeParseException.getMessage(), dateTimeParseException.getParsedString(), dateTimeParseException.getErrorIndex());
            }
        }
        return null;
    }

    public Duration marshal(java.time.Duration value) {
        return value != null ? (value.toDays() < 30L ? this.marshalDayTime(value.toMillis()) : this.marshal(value.toMillis())) : null;
    }

    protected Duration marshalDayTime(long time) {
        return DATATYPE_FACTORY.newDurationDayTime(time);
    }

    protected Duration marshal(long time) {
        return DATATYPE_FACTORY.newDuration(time);
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException();
        }
    }
}

