/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.xml.bind;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import nl.vpro.util.TimeUtils;
import nl.vpro.xml.util.XmlUtils;

public class InstantXmlAdapter
extends XmlAdapter<String, Instant> {
    public static final ThreadLocal<Boolean> OMIT_MILLIS_IF_ZERO = ThreadLocal.withInitial(() -> true);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ").withLocale(Locale.US).withZone(XmlUtils.DEFAULT_ZONE);
    private static final DateTimeFormatter formatterNoMillis = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ").withLocale(Locale.US).withZone(XmlUtils.DEFAULT_ZONE);

    public Instant unmarshal(String dateValue) {
        return TimeUtils.parse((CharSequence)dateValue).orElse(null);
    }

    public String marshal(Instant value) {
        return InstantXmlAdapter.toXMLFormat(value);
    }

    public static String toXMLFormat(Instant value) {
        if (value == null) {
            return null;
        }
        if (value.getNano() == 0 && OMIT_MILLIS_IF_ZERO.get().booleanValue()) {
            return formatterNoMillis.format(value);
        }
        return InstantXmlAdapter.formatWithMillis(value);
    }

    static String formatWithMillis(Instant instant) {
        if (instant == null) {
            return null;
        }
        return formatter.format(instant.plusNanos(500000L).truncatedTo(ChronoUnit.MILLIS));
    }
}

