/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.xml.bind;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import nl.vpro.xml.util.XmlUtils;

public class ZonedDateTimeXmlAdapter
extends XmlAdapter<String, ZonedDateTime> {
    public static final ThreadLocal<Boolean> OMIT_MILLIS_IF_ZERO = ThreadLocal.withInitial(() -> true);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ").withLocale(Locale.US);
    private static final DateTimeFormatter formatterNoMillis = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZZZZZ").withLocale(Locale.US);

    public ZonedDateTime unmarshal(String dateValue) {
        if (dateValue == null) {
            return null;
        }
        try {
            return LocalDate.parse(dateValue).atStartOfDay().atZone(XmlUtils.DEFAULT_ZONE);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return LocalDateTime.parse(dateValue).atZone(XmlUtils.DEFAULT_ZONE);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                return ZonedDateTime.parse(dateValue);
            }
        }
    }

    public String marshal(ZonedDateTime value) {
        if (value == null) {
            return null;
        }
        if (value.getNano() == 0 && OMIT_MILLIS_IF_ZERO.get().booleanValue()) {
            return formatterNoMillis.format(value);
        }
        return formatter.format(value.plusNanos(500000L).truncatedTo(ChronoUnit.MILLIS));
    }
}

