/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.xml.bind;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import nl.vpro.xml.util.XmlUtils;

public class ZonedLocalDateXmlAdapter
extends XmlAdapter<String, LocalDate> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-ddZZZZZ").withLocale(Locale.US);

    public LocalDate unmarshal(String dateValue) {
        if (dateValue == null) {
            return null;
        }
        return LocalDate.parse(dateValue.substring(0, 10));
    }

    public String marshal(LocalDate v) {
        return v.atStartOfDay(XmlUtils.DEFAULT_ZONE).format(FORMATTER);
    }
}

