/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.xml.util;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;

public class XMLStreamWriterUtil {
    private static final XMLOutputFactory FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter writer;
    private final Deque<AutoCloseable> closeables = new ArrayDeque<AutoCloseable>();
    private int currentDepth = 0;

    public XMLStreamWriterUtil(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public XMLStreamWriterUtil(OutputStream outputStream) throws XMLStreamException {
        this(FACTORY.createXMLStreamWriter(outputStream));
    }

    public XMLStreamWriterUtil(Writer writer) throws XMLStreamException {
        this(FACTORY.createXMLStreamWriter(writer));
    }

    public XMLStreamWriterUtil(StringBuilder builder) throws XMLStreamException {
        this(FACTORY.createXMLStreamWriter((Writer)new StringBuilderWriter(builder)));
    }

    public AutoCloseable writeElement(String name) throws XMLStreamException {
        ++this.currentDepth;
        int closeTo = this.currentDepth;
        this.writer.writeStartElement(name);
        AutoCloseable closeable = () -> {
            while (this.currentDepth > closeTo) {
                --this.currentDepth;
                this.closeables.pop().close();
            }
            this.writer.writeEndElement();
        };
        this.closeables.push(closeable);
        return closeable;
    }

    public AutoCloseable writeElement(String namespace, String name) throws XMLStreamException {
        this.writer.writeStartElement(namespace, name);
        return this.writer::writeEndElement;
    }

    public AutoCloseable writeDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
        return this.writer::writeEndDocument;
    }

    public AutoCloseable writeDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
        return this.writer::writeEndDocument;
    }

    public AutoCloseable writeDocument(Charset charset, String version) throws XMLStreamException {
        this.writer.writeStartDocument(charset.toString(), version);
        return this.writer::writeEndDocument;
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(localName);
    }

    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    public void writeComment(String data) throws XMLStreamException {
        this.writer.writeComment(data);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    public void writeCData(String data) throws XMLStreamException {
        this.writer.writeCData(data);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.writer.writeCharacters(text);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(text, start, len);
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }
}

