/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.xml.util;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import lombok.Generated;
import nl.vpro.util.BindingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);
    public static final ZoneId DEFAULT_ZONE = BindingUtils.DEFAULT_ZONE;
    static final DatatypeFactory FACTORY;

    private XmlUtils() {
    }

    @Deprecated
    public static Date toDate(XMLGregorianCalendar in) {
        return in == null ? null : in.toGregorianCalendar().getTime();
    }

    public static Instant toInstant(ZoneId defaultZoneId, XMLGregorianCalendar in) {
        if (in == null) {
            return null;
        }
        if (in.getTimezone() == Integer.MIN_VALUE) {
            TimeZone zone;
            if (defaultZoneId != null) {
                zone = TimeZone.getTimeZone(defaultZoneId);
            } else {
                zone = TimeZone.getTimeZone(DEFAULT_ZONE);
                log.info("{} defines no timezone. Falling back to {}", (Object)in, (Object)DEFAULT_ZONE);
            }
            return in.toGregorianCalendar(zone, Locale.US, in).getTime().toInstant();
        }
        return in.toGregorianCalendar().getTime().toInstant();
    }

    public static ZonedDateTime toZonedDateTime(ZoneId zoneId, XMLGregorianCalendar in) {
        Instant instant = XmlUtils.toInstant(zoneId, in);
        return instant == null ? null : instant.atZone(zoneId);
    }

    public static OffsetDateTime toOffsetDateTime(ZoneId zoneId, XMLGregorianCalendar in) {
        Instant instant = XmlUtils.toInstant(zoneId, in);
        return instant == null ? null : instant.atZone(zoneId).toOffsetDateTime();
    }

    public static Instant toInstant(XMLGregorianCalendar in) {
        return XmlUtils.toInstant(DEFAULT_ZONE, in);
    }

    @Deprecated
    public static XMLGregorianCalendar toXml(Date date) {
        if (date == null) {
            return null;
        }
        return XmlUtils.toXml(DEFAULT_ZONE, date.toInstant());
    }

    public static XMLGregorianCalendar toXml(ZoneId zoneId, Instant date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(Date.from(date));
        if (zoneId != null) {
            c.setTimeZone(TimeZone.getTimeZone(zoneId));
        }
        return FACTORY.newXMLGregorianCalendar(c);
    }

    static {
        try {
            FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException();
        }
    }
}

