/*
 * Decompiled with CFR 0.152.
 */
package nl.yannickl88.language;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.yannickl88.language.EntityMatchable;

class Classifier {
    public final String action;
    private HashMap<String, Integer> wordCount;
    private ArrayList<EntityMatchable> matchers;
    private int totalUtterances = 0;
    private int totalWords = 0;

    static ArrayList<String> getWords(String message) {
        Pattern p = Pattern.compile("([\\w\\a]+)");
        Matcher m = p.matcher(message);
        ArrayList<String> words = new ArrayList<String>();
        while (m.find()) {
            words.add(m.group().toLowerCase());
        }
        return words;
    }

    Classifier(String action) {
        this.action = action;
        this.wordCount = new HashMap();
        this.matchers = new ArrayList();
    }

    int getWordCount(String word) {
        if (!this.wordCount.containsKey(word)) {
            return 0;
        }
        return this.wordCount.get(word);
    }

    List<String> getWords() {
        return new ArrayList<String>(this.wordCount.keySet());
    }

    void addUtterance(List<String> words) {
        ++this.totalUtterances;
        this.totalWords += words.size();
        for (String word : words) {
            this.wordCount.put(word, this.getWordCount(word) + 1);
        }
    }

    int getTotalUtterances() {
        return this.totalUtterances;
    }

    int getTotalWords() {
        return this.totalWords;
    }

    public void addMatcher(EntityMatchable matcher) {
        this.matchers.add(matcher);
    }

    public List<EntityMatchable> getMatchers() {
        return this.matchers;
    }
}

