/*
 * Decompiled with CFR 0.152.
 */
package nl.yannickl88.language;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.yannickl88.language.Classifier;
import nl.yannickl88.language.EntityMatchable;
import nl.yannickl88.language.IntentMatcherLoadable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntentMatcherLoader {
    public void load(IntentMatcherLoadable processor, File file) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            NodeList intents = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < intents.getLength(); ++i) {
                Node node = intents.item(i);
                if (!"intent".equals(node.getNodeName())) continue;
                NodeList intentMatchers = node.getChildNodes();
                Classifier intent = new Classifier(node.getAttributes().getNamedItem("action").getNodeValue());
                for (int j = 0; j < intentMatchers.getLength(); ++j) {
                    EntityMatchable matcherLoader;
                    Node matcher = intentMatchers.item(j);
                    if ("utterance".equals(matcher.getNodeName())) {
                        intent.addUtterance(Classifier.getWords(matcher.getFirstChild().getTextContent()));
                        continue;
                    }
                    if (!"matcher".equals(matcher.getNodeName()) || null == (matcherLoader = this.getWordMatcherLoader(matcher.getFirstChild().getTextContent()))) continue;
                    intent.addMatcher(matcherLoader);
                }
                processor.addIntentMatcher(intent);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private EntityMatchable getWordMatcherLoader(String matcherName) {
        try {
            Class<?> c = Class.forName(matcherName);
            return (EntityMatchable)c.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }
}

