/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import no.acando.xmltordf.Builder;
import no.acando.xmltordf.CompositeId;
import no.acando.xmltordf.Element;
import no.acando.xmltordf.Property;
import no.acando.xmltordf.StringTransformTwoValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class AdvancedSaxHandler<ResourceType, Datatype>
extends DefaultHandler {
    private final Deque<Element<ResourceType, Datatype>> elementStack = new ArrayDeque<Element<ResourceType, Datatype>>(100);
    static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    Builder.Advanced<ResourceType, Datatype, ? extends Builder.Advanced> builder;
    private long uriCounter = 0L;
    private long index = 0L;
    private Element<ResourceType, Datatype> skipElementUntil = null;
    private final Element<ResourceType, Datatype> skippableElement = new Element<ResourceType, Datatype>(this, this.builder);
    HashMap<String, String> prefixUriMap = new HashMap();

    AdvancedSaxHandler(Builder.Advanced<ResourceType, Datatype, ? extends Builder.Advanced> builder) {
        this.builder = builder;
    }

    abstract void createTriple(String var1, String var2, String var3);

    abstract void createTripleLiteral(String var1, String var2, String var3);

    abstract void createTripleLiteral(String var1, String var2, long var3);

    abstract void createList(String var1, String var2, List<Object> var3);

    abstract void createTripleLiteral(String var1, String var2, String var3, Datatype var4);

    abstract void createTriple(String var1, String var2, ResourceType var3);

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            this.elementStack.peek().appendValue(ch, start, length);
        }
    }

    @Override
    public void endElement(String namespace, String localName, String qName) throws SAXException {
        Element<ResourceType, Datatype> pop = this.elementStack.pop();
        if (pop == this.skippableElement) {
            return;
        }
        if (this.skipElementUntil != null && pop == this.skipElementUntil) {
            this.skipElementUntil = null;
            return;
        }
        pop.createTriples();
    }

    Optional<ResourceType> mapLiteralToResource(Element pop) {
        Object value;
        Map stringResourceTypeMap;
        if (this.builder.literalMap != null && (stringResourceTypeMap = this.builder.literalMap.get(pop.type)) != null && (value = stringResourceTypeMap.get(pop.getHasValue())) != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.skipElementUntil != null) {
            this.elementStack.push(this.skippableElement);
            return;
        }
        boolean mixedContent = this.detectMixedContent();
        if (this.builder.xsiTypeSupport && attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null) {
            String type = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type.contains(":")) {
                String[] split = type.split(":");
                namespace = this.prefixUriMap.get(split[0]);
                localName = split[1];
            } else {
                localName = type;
            }
        }
        Element<ResourceType, Datatype> element = new Element<ResourceType, Datatype>(this, this.builder);
        element.index = this.index++;
        namespace = this.calculateNamespace(namespace);
        element.type = namespace + localName;
        if (this.builder.skipElementMap != null && this.builder.skipElementMap.containsKey(element.type)) {
            this.skipElementUntil = element;
            this.elementStack.push(element);
            return;
        }
        Element<ResourceType, Datatype> parent = null;
        if (!this.elementStack.isEmpty()) {
            parent = this.elementStack.peek();
            if (this.builder.addIndex) {
                element.elementIndex = parent.indexMap.plusPlus(element.type);
            }
            parent.hasChild.add(element);
            if (mixedContent) {
                parent.addMixedContent(element);
            }
        }
        element.parent = parent;
        this.renameElement(namespace, localName, element);
        if (this.builder.forcedMixedContentMap != null && this.builder.forcedMixedContentMap.containsKey(element.type)) {
            element.containsMixedContent = true;
        }
        if (this.builder.compositeIdMap != null) {
            CompositeId compositeId = this.builder.compositeIdMap.get(element.type);
            if (compositeId == null) {
                this.calculateNodeId(namespace, element);
            } else {
                element.compositeId = compositeId.simpleClone();
            }
        } else {
            this.calculateNodeId(namespace, element);
        }
        this.handleAttributes(namespace, attributes, element);
        if (this.builder.useElementAsPredicateMap != null && this.builder.useElementAsPredicateMap.containsKey(element.type)) {
            element.useElementAsPredicate = true;
        }
        this.builder.doComplexTransformElementAtStartOfElement(element);
        this.elementStack.push(element);
    }

    private void handleAttributes(String elementNamespace, Attributes attributes, Element<ResourceType, Datatype> element) {
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String uriAttr = attributes.getURI(i);
            String nameAttr = attributes.getLocalName(i);
            String valueAttr = attributes.getValue(i);
            if (this.builder.xsiTypeSupport && uriAttr.equals("http://www.w3.org/2001/XMLSchema-instance") && nameAttr.equals("type")) continue;
            uriAttr = this.calculateNamespaceForAttribute(elementNamespace, uriAttr);
            valueAttr = this.builder.doTransformForAttribute(element.type, uriAttr + nameAttr, valueAttr);
            if (this.builder.resolveAsQnameInAttributeValue && valueAttr.contains(":")) {
                CharSequence[] split = valueAttr.split(":");
                split[0] = this.prefixUriMap.get(split[0]);
                valueAttr = String.join((CharSequence)"", split);
            }
            this.builder.getIdByUseAttributeForId(element.type, uriAttr + nameAttr, valueAttr, element);
            Property property = new Property(uriAttr, nameAttr, valueAttr);
            element.properties.add(property);
            if (element.compositeId == null) continue;
            element.compositeId.resolveAttribute(uriAttr + nameAttr, valueAttr);
        }
    }

    private String calculateNamespaceForAttribute(String elementNamespace, String uriAttr) {
        if (this.builder.overrideNamespace != null) {
            uriAttr = this.builder.overrideNamespace;
        }
        if (!(this.builder.autoAddSuffixToNamespace == null || uriAttr == null || uriAttr.isEmpty() || uriAttr.endsWith("/") || uriAttr.endsWith("#"))) {
            uriAttr = uriAttr + this.builder.autoAddSuffixToNamespace;
        }
        if (uriAttr == null || uriAttr.isEmpty()) {
            if (this.builder.autoAttributeNamespace && elementNamespace != null && !elementNamespace.isEmpty()) {
                uriAttr = elementNamespace;
            } else if (this.builder.baseNamespace != null && (this.builder.baseNamespaceAppliesTo == Builder.AppliesTo.justAttributes || this.builder.baseNamespaceAppliesTo == Builder.AppliesTo.bothElementsAndAttributes)) {
                uriAttr = this.builder.baseNamespace;
            }
        }
        return uriAttr;
    }

    private void calculateNodeId(String uri, Element<ResourceType, Datatype> element) {
        if (this.builder.uuidBasedIdInsteadOfBlankNodes) {
            String tempUri = uri;
            if (this.builder.overrideNamespace != null) {
                tempUri = this.builder.overrideNamespace;
            }
            element.uri = tempUri + UUID.randomUUID().toString();
        } else {
            element.uri = "_:" + this.uriCounter++;
        }
    }

    private void renameElement(String uri, String localName, Element<ResourceType, Datatype> element) {
        StringTransformTwoValue stringTransformTwoValue;
        String newElementName;
        if (this.builder.renameElementPathMap != null && (newElementName = this.builder.renameElementPathMap.get(element)) != null) {
            element.type = newElementName;
            return;
        }
        if (this.builder.renameElementMap != null && (newElementName = (String)this.builder.renameElementMap.get(uri + localName)) != null) {
            element.type = newElementName;
            return;
        }
        if (this.builder.renameElementFunctionMap != null && (stringTransformTwoValue = (StringTransformTwoValue)this.builder.renameElementFunctionMap.get(uri + localName)) != null) {
            element.type = stringTransformTwoValue.transform(uri, localName);
        }
    }

    private String calculateNamespace(String uri) {
        if (this.builder.overrideNamespace != null) {
            return this.builder.overrideNamespace;
        }
        if (!(this.builder.autoAddSuffixToNamespace == null || uri == null || uri.isEmpty() || uri.endsWith("/") || uri.endsWith("#"))) {
            uri = uri + this.builder.autoAddSuffixToNamespace;
        }
        if (!(uri != null && !uri.isEmpty() || this.builder.baseNamespace == null || this.builder.baseNamespaceAppliesTo != Builder.AppliesTo.justElements && this.builder.baseNamespaceAppliesTo != Builder.AppliesTo.bothElementsAndAttributes)) {
            uri = this.builder.baseNamespace;
        }
        return uri;
    }

    private boolean detectMixedContent() {
        if (this.elementStack.size() > 0) {
            Element<ResourceType, Datatype> peek = this.elementStack.peek();
            if (peek.containsMixedContent) {
                return true;
            }
            if (peek.getHasValue() != null) {
                return true;
            }
        }
        return false;
    }

    static boolean isBlankNode(String node) {
        return node.startsWith("_:");
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!(this.builder.autoAddSuffixToNamespace == null || uri == null || uri.isEmpty() || uri.endsWith("/") || uri.endsWith("#"))) {
            uri = uri + this.builder.autoAddSuffixToNamespace;
        }
        if ((uri == null || uri.isEmpty()) && this.builder.baseNamespace != null) {
            uri = this.builder.baseNamespace;
        }
        if (this.builder.overrideNamespace != null) {
            uri = this.builder.overrideNamespace;
        }
        this.prefixUriMap.put(prefix, uri);
    }
}

