/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import no.acando.xmltordf.AdvancedSaxHandler;
import no.acando.xmltordf.Builder;
import no.acando.xmltordf.CustomBlockingQueue;
import no.acando.xmltordf.Element;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.openrdf.model.vocabulary.RDF;
import org.xml.sax.SAXException;

final class AdvancedSaxHandlerJena
extends AdvancedSaxHandler<Node, RDFDatatype> {
    private static final Node RDF_REST = NodeFactory.createURI((String)RDF.REST.toString());
    private static final Node RDF_FIRST = NodeFactory.createURI((String)RDF.FIRST.toString());
    private static final Node RDF_NIL = NodeFactory.createURI((String)RDF.NIL.toString());
    private Graph graph;
    Dataset dataset;
    private BlockingQueue<Triple> queue;
    private boolean notDone = true;
    private Thread jenaThread;
    private final Triple EndOfFileTriple = new Triple(NodeFactory.createURI((String)"http://acandonorway.github.com/XmlToRdf/ontology.ttl#EndOfFile"), NodeFactory.createURI((String)"http://acandonorway.github.com/XmlToRdf/ontology.ttl#EndOfFile"), NodeFactory.createURI((String)"http://acandonorway.github.com/XmlToRdf/ontology.ttl#EndOfFile"));

    AdvancedSaxHandlerJena(Builder.AdvancedJena builder) {
        super(builder);
        this.queue = new CustomBlockingQueue<Triple>(builder.buffer);
        this.dataset = DatasetFactory.createMem();
        this.graph = this.dataset.getDefaultModel().getGraph();
        this.builder = builder;
        Thread thread = Thread.currentThread();
        this.jenaThread = new Thread(){

            @Override
            public void run() {
                while (AdvancedSaxHandlerJena.this.notDone || !AdvancedSaxHandlerJena.this.queue.isEmpty()) {
                    try {
                        Triple take = (Triple)AdvancedSaxHandlerJena.this.queue.take();
                        if (take == AdvancedSaxHandlerJena.this.EndOfFileTriple) continue;
                        ((GraphWithPerform)AdvancedSaxHandlerJena.this.graph).performAdd(take);
                    }
                    catch (InterruptedException e) {
                        System.out.println(e.getMessage());
                    }
                }
                AdvancedSaxHandlerJena.this.prefixUriMap.forEach((arg_0, arg_1) -> ((Model)AdvancedSaxHandlerJena.this.dataset.getDefaultModel()).setNsPrefix(arg_0, arg_1));
                AdvancedSaxHandlerJena.this.dataset.getDefaultModel().setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
                AdvancedSaxHandlerJena.this.dataset.getDefaultModel().setNsPrefix("xmlTodRdf", "http://acandonorway.github.com/XmlToRdf/ontology.ttl#");
            }
        };
        this.jenaThread.start();
    }

    @Override
    public final void createTriple(String subject, String predicate, String object) {
        Node predicateNode = NodeFactory.createURI((String)predicate);
        Node subjectNode = null;
        Node objectNode = null;
        subjectNode = AdvancedSaxHandlerJena.getNode(subject);
        objectNode = AdvancedSaxHandlerJena.getNode(object);
        this.addTripleToQueue(subjectNode, predicateNode, objectNode);
    }

    @Override
    public final void createTriple(String subject, String predicate, Node objectNode) {
        Node predicateNode = NodeFactory.createURI((String)predicate);
        Node subjectNode = null;
        subjectNode = AdvancedSaxHandlerJena.getNode(subject);
        this.addTripleToQueue(subjectNode, predicateNode, objectNode);
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, String objectLiteral) {
        if (objectLiteral == null) {
            return;
        }
        Node predicateNode = NodeFactory.createURI((String)predicate);
        Node subjectNode = null;
        subjectNode = AdvancedSaxHandlerJena.getNode(subject);
        Node literal = null;
        if (this.builder.autoTypeLiterals) {
            try {
                Integer.parseInt(objectLiteral);
                literal = NodeFactory.createLiteral((String)objectLiteral, (RDFDatatype)XSDDatatype.XSDinteger);
            }
            catch (NumberFormatException e) {
                try {
                    Double.parseDouble(objectLiteral);
                    literal = NodeFactory.createLiteral((String)objectLiteral, (RDFDatatype)XSDDatatype.XSDdecimal);
                }
                catch (NumberFormatException e2) {
                    try {
                        LocalDateTime.parse(objectLiteral, DateTimeFormatter.ISO_DATE_TIME);
                        literal = NodeFactory.createLiteral((String)objectLiteral, (RDFDatatype)XSDDatatype.XSDdateTime);
                    }
                    catch (DateTimeParseException e3) {
                        try {
                            LocalDate.parse(objectLiteral, DateTimeFormatter.ISO_DATE);
                            literal = NodeFactory.createLiteral((String)objectLiteral, (RDFDatatype)XSDDatatype.XSDdate);
                        }
                        catch (DateTimeParseException e4) {
                            literal = NodeFactory.createLiteral((String)objectLiteral, null, (boolean)false);
                        }
                    }
                }
            }
        } else {
            literal = NodeFactory.createLiteral((String)objectLiteral, null, (boolean)false);
        }
        this.addTripleToQueue(subjectNode, predicateNode, literal);
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, String objectLiteral, RDFDatatype datatype) {
        if (objectLiteral == null) {
            return;
        }
        Node predicateNode = NodeFactory.createURI((String)predicate);
        Node subjectNode = null;
        subjectNode = AdvancedSaxHandlerJena.getNode(subject);
        Node literal = NodeFactory.createLiteral((String)objectLiteral, (RDFDatatype)datatype);
        this.addTripleToQueue(subjectNode, predicateNode, literal);
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, long objectLong) {
        Node predicateNode = NodeFactory.createURI((String)predicate);
        Node subjectNode = null;
        subjectNode = AdvancedSaxHandlerJena.getNode(subject);
        Node literal = NodeFactory.createLiteral((String)(objectLong + ""), (RDFDatatype)XSDDatatype.XSDlong);
        this.addTripleToQueue(subjectNode, predicateNode, literal);
    }

    @Override
    public final void createList(String subject, String predicate, List<Object> mixedContent) {
        Node predicateNode = NodeFactory.createURI((String)predicate);
        Node subjectNode = AdvancedSaxHandlerJena.getNode(subject);
        Node[] head = new Node[1];
        Node[] temporaryNode = new Node[1];
        mixedContent.stream().map(content -> {
            if (content instanceof String) {
                String objectLiteral = (String)content;
                return NodeFactory.createLiteral((String)objectLiteral, (RDFDatatype)XSDDatatype.XSDstring);
            }
            if (content instanceof Element) {
                Element objectElement = (Element)content;
                if (AdvancedSaxHandlerJena.isBlankNode(objectElement.uri)) {
                    return NodeFactory.createBlankNode((String)objectElement.uri);
                }
                return NodeFactory.createURI((String)objectElement.uri);
            }
            throw new IllegalStateException("Unknown type of: " + content.getClass().toString());
        }).forEachOrdered(value -> {
            Node blankNode = NodeFactory.createBlankNode();
            if (head[0] == null) {
                nodeArray[0] = blankNode;
                this.addTripleToQueue(head[0], RDF_FIRST, (Node)value);
            } else {
                this.addTripleToQueue(temporaryNode[0], RDF_REST, blankNode);
                this.addTripleToQueue(blankNode, RDF_FIRST, (Node)value);
            }
            nodeArray2[0] = blankNode;
        });
        this.addTripleToQueue(temporaryNode[0], RDF_REST, RDF_NIL);
        this.addTripleToQueue(subjectNode, predicateNode, head[0]);
    }

    private void addTripleToQueue(Node subjectNode, Node predicateNode, Node objectNode) {
        Triple triple = new Triple(subjectNode, predicateNode, objectNode);
        try {
            this.queue.put(triple);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Node getNode(String subject) {
        if (!AdvancedSaxHandlerJena.isBlankNode(subject)) {
            return NodeFactory.createURI((String)subject);
        }
        return NodeFactory.createBlankNode((String)subject);
    }

    @Override
    public void endDocument() throws SAXException {
        this.notDone = false;
        try {
            this.queue.put(this.EndOfFileTriple);
            this.jenaThread.join();
        }
        catch (InterruptedException e) {
            System.out.println(e.getMessage());
        }
    }
}

