/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import no.acando.xmltordf.AdvancedSaxHandler;
import no.acando.xmltordf.Builder;
import no.acando.xmltordf.CustomBlockingQueue;
import no.acando.xmltordf.Element;
import org.openrdf.IsolationLevel;
import org.openrdf.IsolationLevels;
import org.openrdf.model.BNode;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.Repository;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.xml.sax.SAXException;

final class AdvancedSaxHandlerSesame
extends AdvancedSaxHandler<IRI, IRI> {
    Repository repository;
    private BlockingQueue<Statement> queue;
    private boolean notDone = true;
    private Thread repoThread;
    private static final SimpleValueFactory valueFactory = SimpleValueFactory.getInstance();
    private static final Statement EndOfFileStatement = SimpleValueFactory.getInstance().createStatement((Resource)valueFactory.createIRI("http://acandonorway.github.com/XmlToRdf/ontology.ttl#EndOfFile"), valueFactory.createIRI("http://acandonorway.github.com/XmlToRdf/ontology.ttl#EndOfFile"), (Value)valueFactory.createIRI("http://acandonorway.github.com/XmlToRdf/ontology.ttl#EndOfFile"));

    AdvancedSaxHandlerSesame(Builder.AdvancedSesame builder) {
        super(builder);
        this.queue = new CustomBlockingQueue<Statement>(builder.buffer);
        final MemoryStore memoryStore = new MemoryStore();
        memoryStore.initialize();
        this.builder = builder;
        this.repoThread = new Thread(){

            @Override
            public void run() {
                NotifyingSailConnection connection = memoryStore.getConnection();
                connection.begin((IsolationLevel)IsolationLevels.NONE);
                while (AdvancedSaxHandlerSesame.this.notDone || !AdvancedSaxHandlerSesame.this.queue.isEmpty()) {
                    try {
                        Statement take = (Statement)AdvancedSaxHandlerSesame.this.queue.take();
                        if (take == EndOfFileStatement) continue;
                        connection.addStatement(take.getSubject(), take.getPredicate(), take.getObject(), new Resource[0]);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println(interruptedException.getMessage());
                    }
                }
                AdvancedSaxHandlerSesame.this.prefixUriMap.forEach((arg_0, arg_1) -> ((NotifyingSailConnection)connection).setNamespace(arg_0, arg_1));
                connection.setNamespace("xsd", "http://www.w3.org/2001/XMLSchema#");
                connection.commit();
                connection.close();
                AdvancedSaxHandlerSesame.this.repository = new SailRepository((Sail)memoryStore);
            }
        };
        this.repoThread.start();
    }

    @Override
    public final void createTriple(String subject, String predicate, String object) {
        IRI predicateNode = valueFactory.createIRI(predicate);
        Resource subjectNode = AdvancedSaxHandlerSesame.getResource(subject);
        Resource objectNode = AdvancedSaxHandlerSesame.getResource(object);
        this.addTripleToQueue(subjectNode, predicateNode, (Value)objectNode);
    }

    @Override
    public final void createTriple(String subject, String predicate, IRI objectNode) {
        IRI predicateNode = valueFactory.createIRI(predicate);
        Resource subjectNode = AdvancedSaxHandlerSesame.getResource(subject);
        this.addTripleToQueue(subjectNode, predicateNode, (Value)objectNode);
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, String objectLiteral, IRI datatype) {
        if (objectLiteral == null) {
            return;
        }
        IRI predicateNode = valueFactory.createIRI(predicate);
        Resource subjectNode = AdvancedSaxHandlerSesame.getResource(subject);
        Literal literal = valueFactory.createLiteral(objectLiteral, datatype);
        this.addTripleToQueue(subjectNode, predicateNode, (Value)literal);
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, String objectLiteral) {
        if (objectLiteral == null) {
            return;
        }
        IRI predicateNode = valueFactory.createIRI(predicate);
        Resource subjectNode = AdvancedSaxHandlerSesame.getResource(subject);
        Literal literal = null;
        if (this.builder.autoTypeLiterals) {
            try {
                Integer.parseInt(objectLiteral);
                literal = valueFactory.createLiteral(objectLiteral, XMLSchema.INTEGER);
            }
            catch (NumberFormatException e) {
                try {
                    Double.parseDouble(objectLiteral);
                    literal = valueFactory.createLiteral(objectLiteral, XMLSchema.DECIMAL);
                }
                catch (NumberFormatException e2) {
                    try {
                        LocalDateTime.parse(objectLiteral, DateTimeFormatter.ISO_DATE_TIME);
                        literal = valueFactory.createLiteral(objectLiteral, XMLSchema.DATETIME);
                    }
                    catch (DateTimeParseException e3) {
                        try {
                            LocalDate.parse(objectLiteral, DateTimeFormatter.ISO_DATE);
                            literal = valueFactory.createLiteral(objectLiteral, XMLSchema.DATE);
                        }
                        catch (DateTimeParseException e4) {
                            literal = valueFactory.createLiteral(objectLiteral);
                        }
                    }
                }
            }
        } else {
            literal = valueFactory.createLiteral(objectLiteral);
        }
        this.addTripleToQueue(subjectNode, predicateNode, (Value)literal);
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, long objectLong) {
        IRI predicateNode = valueFactory.createIRI(predicate);
        Resource subjectNode = AdvancedSaxHandlerSesame.getResource(subject);
        Literal literal = valueFactory.createLiteral(objectLong);
        this.addTripleToQueue(subjectNode, predicateNode, (Value)literal);
    }

    @Override
    public final void createList(String subject, String predicate, List<Object> mixedContent) {
        IRI predicateNode = valueFactory.createIRI(predicate);
        Resource subjectNode = AdvancedSaxHandlerSesame.getResource(subject);
        Resource[] head = new Resource[1];
        Resource[] temporaryNode = new Resource[1];
        mixedContent.stream().map(content -> {
            if (content instanceof String) {
                String objectLiteral = (String)content;
                return valueFactory.createLiteral(objectLiteral);
            }
            if (content instanceof Element) {
                Element objectElement = (Element)content;
                if (!objectElement.uri.startsWith("_:")) {
                    return valueFactory.createIRI(objectElement.uri);
                }
                return valueFactory.createBNode(objectElement.uri);
            }
            throw new IllegalStateException("Unknown type of: " + content.getClass().toString());
        }).forEachOrdered(value -> {
            BNode blankNode = valueFactory.createBNode();
            if (head[0] == null) {
                resourceArray[0] = blankNode;
                this.addTripleToQueue(head[0], RDF.FIRST, (Value)value);
            } else {
                this.addTripleToQueue(temporaryNode[0], RDF.REST, (Value)blankNode);
                this.addTripleToQueue((Resource)blankNode, RDF.FIRST, (Value)value);
            }
            resourceArray2[0] = blankNode;
        });
        this.addTripleToQueue(temporaryNode[0], RDF.REST, (Value)RDF.NIL);
        this.addTripleToQueue(subjectNode, predicateNode, (Value)head[0]);
    }

    @Override
    public final void endDocument() throws SAXException {
        this.notDone = false;
        try {
            this.queue.put(EndOfFileStatement);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        try {
            this.repoThread.join();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private static Resource getResource(String subject) {
        if (!AdvancedSaxHandlerSesame.isBlankNode(subject)) {
            return valueFactory.createIRI(subject);
        }
        return valueFactory.createBNode(subject);
    }

    private void addTripleToQueue(Resource subject, IRI predicate, Value object) {
        try {
            Statement statement = valueFactory.createStatement(subject, predicate, object);
            this.queue.put(statement);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

