/*
 * Decompiled with CFR 0.152.
 */
package no.acando.xmltordf;

import java.io.OutputStream;
import java.io.PrintStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import no.acando.xmltordf.AdvancedSaxHandler;
import no.acando.xmltordf.Builder;
import no.acando.xmltordf.Element;
import org.xml.sax.SAXException;

final class AdvancedSaxHandlerString
extends AdvancedSaxHandler<String, String> {
    private final PrintStream out;

    AdvancedSaxHandlerString(OutputStream out, Builder.AdvancedStream builder) {
        super(builder);
        this.out = new PrintStream(out);
    }

    @Override
    public final void createTriple(String subject, String predicate, String object) {
        boolean objectIsBlank = AdvancedSaxHandlerString.isBlankNode(object);
        if (AdvancedSaxHandlerString.isBlankNode(subject)) {
            if (objectIsBlank) {
                this.out.println(subject + " <" + predicate + "> " + object + '.');
            } else {
                this.out.println(subject + " <" + predicate + "> <" + object + ">.");
            }
        } else if (objectIsBlank) {
            this.out.println('<' + subject + "> <" + predicate + "> " + object + '.');
        } else {
            this.out.println('<' + subject + "> <" + predicate + "> <" + object + ">.");
        }
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, String objectLiteral) {
        objectLiteral = objectLiteral.replace("\\", "\\\\").replace("\"", "\\\"");
        String datatype = "";
        if (this.builder.autoTypeLiterals) {
            try {
                Integer.parseInt(objectLiteral);
                datatype = "^^<http://www.w3.org/2001/XMLSchema#integer>";
            }
            catch (NumberFormatException e) {
                try {
                    Double.parseDouble(objectLiteral);
                    datatype = "^^<http://www.w3.org/2001/XMLSchema#decimal>";
                }
                catch (NumberFormatException e2) {
                    try {
                        LocalDateTime.parse(objectLiteral, DateTimeFormatter.ISO_DATE_TIME);
                        datatype = "^^<http://www.w3.org/2001/XMLSchema#dateTime>";
                    }
                    catch (DateTimeParseException e3) {
                        try {
                            LocalDate.parse(objectLiteral, DateTimeFormatter.ISO_DATE);
                            datatype = "^^<http://www.w3.org/2001/XMLSchema#date>";
                        }
                        catch (DateTimeParseException e4) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (!AdvancedSaxHandlerString.isBlankNode(subject)) {
            this.out.println('<' + subject + "> <" + predicate + "> \"\"\"" + objectLiteral + "\"\"\"" + datatype + " .");
        } else {
            this.out.println(subject + " <" + predicate + "> \"\"\"" + objectLiteral + "\"\"\"" + datatype + " .");
        }
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, long objectLong) {
        if (!AdvancedSaxHandlerString.isBlankNode(subject)) {
            this.out.println('<' + subject + "> <" + predicate + "> \"" + objectLong + "\"^^<http://www.w3.org/2001/XMLSchema#long>" + " .");
        } else {
            this.out.println(subject + " <" + predicate + "> \"" + objectLong + "\"^^<http://www.w3.org/2001/XMLSchema#long>" + " .");
        }
    }

    @Override
    public final void createList(String subject, String predicate, List<Object> mixedContent) {
        predicate = '<' + predicate + '>';
        if (!AdvancedSaxHandlerString.isBlankNode(subject)) {
            subject = '<' + subject + '>';
        }
        StringBuilder stringBuilder = new StringBuilder(subject + ' ' + predicate + " (");
        mixedContent.forEach(content -> {
            if (content instanceof String) {
                String objectLiteral = (String)content;
                objectLiteral = objectLiteral.replace("\\", "\\\\").replace("\"", "\\\"");
                stringBuilder.append("\"\"\"" + objectLiteral + "\"\"\" ");
            } else if (content instanceof Element) {
                Element objectElement = (Element)content;
                if (AdvancedSaxHandlerString.isBlankNode(objectElement.uri)) {
                    stringBuilder.append(objectElement.uri + ' ');
                } else {
                    stringBuilder.append('<' + objectElement.uri + "> ");
                }
            } else {
                throw new IllegalStateException("Unknown type of: " + content.getClass().toString());
            }
        });
        this.out.println(stringBuilder.append(").").toString());
    }

    @Override
    public final void createTripleLiteral(String subject, String predicate, String objectLiteral, String dataType) {
        objectLiteral = objectLiteral.replace("\\", "\\\\").replace("\"", "\\\"");
        if (AdvancedSaxHandlerString.isBlankNode(subject)) {
            this.out.println(subject + " <" + predicate + "> \"\"\"" + objectLiteral + "\"\"\"^^<" + dataType + "> .");
        } else {
            this.out.println('<' + subject + "> <" + predicate + "> \"\"\"" + objectLiteral + "\"\"\"^^<" + dataType + "> .");
        }
    }

    @Override
    public final void endDocument() throws SAXException {
        this.out.flush();
        this.out.close();
    }
}

